% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set_Interval_SpecialSet.R
\name{SpecialSet}
\alias{SpecialSet}
\title{Abstract Class for Special Sets}
\description{
The 'special sets' are the group of sets that are commonly used in mathematics
and are thus given their own names.
}
\details{
This is an abstract class and should not be constructed directly. Use \link{listSpecialSets}
to see the list of implemented special sets.
}
\section{Super classes}{
\code{\link[set6:Set]{set6::Set}} -> \code{\link[set6:Interval]{set6::Interval}} -> \code{SpecialSet}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SpecialSet$new()}}
\item \href{#method-strprint}{\code{SpecialSet$strprint()}}
\item \href{#method-clone}{\code{SpecialSet$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="add">}\href{../../set6/html/Set.html#method-add}{\code{set6::Set$add()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="multiplicity">}\href{../../set6/html/Set.html#method-multiplicity}{\code{set6::Set$multiplicity()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="print">}\href{../../set6/html/Set.html#method-print}{\code{set6::Set$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="remove">}\href{../../set6/html/Set.html#method-remove}{\code{set6::Set$remove()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="summary">}\href{../../set6/html/Set.html#method-summary}{\code{set6::Set$summary()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Interval" data-id="contains">}\href{../../set6/html/Interval.html#method-contains}{\code{set6::Interval$contains()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Interval" data-id="equals">}\href{../../set6/html/Interval.html#method-equals}{\code{set6::Interval$equals()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Interval" data-id="isSubinterval">}\href{../../set6/html/Interval.html#method-isSubinterval}{\code{set6::Interval$isSubinterval()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Interval" data-id="isSubset">}\href{../../set6/html/Interval.html#method-isSubset}{\code{set6::Interval$isSubset()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\code{SpecialSet} is an abstract class, the constructor cannot be used directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialSet$new(lower = -Inf, upper = Inf, type = "()", class = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lower}}{defines the lower bound of the interval.}

\item{\code{upper}}{defines the upper bound of the interval.}

\item{\code{type}}{defines the interval closure type.}

\item{\code{class}}{defines the interval class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-strprint"></a>}}
\if{latex}{\out{\hypertarget{method-strprint}{}}}
\subsection{Method \code{strprint()}}{
Creates a printable representation of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialSet$strprint(n = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{ignored, added for consistency.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character string representing the object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
