% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Properties.R
\name{Properties}
\alias{Properties}
\title{Set Properties Class}
\description{
Used to store the properties of a \link{Set}. Though this is not an abstract class,
it should never be constructed outside of the \link{Set} constructor.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{closure}}{Returns the closure of the \code{Set}. One of "open", "half-open", or "closed."}

\item{\code{countability}}{Returns the countability of the \code{Set}. One of "countably finite", "countably infinite", or "uncountable".}

\item{\code{cardinality}}{Returns the cardinality of the \code{Set}. Either an integer if the \code{Set} is countably finite, Aleph0 if countably infinite, or a Beth number.}

\item{\code{empty}}{Returns if the \code{Set} is empty or not. \code{TRUE} if the Set cardinality is \code{0}, \code{FALSE} otherwise.}

\item{\code{singleton}}{Returns if the \code{Set} is a singleton or not. \code{TRUE} if the Set cardinality is \code{1}, \code{FALSE} otherwise.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Properties$new()}}
\item \href{#method-print}{\code{Properties$print()}}
\item \href{#method-strprint}{\code{Properties$strprint()}}
\item \href{#method-clone}{\code{Properties$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Creates a new \code{Properties} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Properties$new(closure = character(0), cardinality = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{closure}}{One of "open", "half-open", or "closed."}

\item{\code{cardinality}}{If non-\code{NULL} then either an integer, "Aleph0", or a Beth number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Properties} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
Prints the \code{Properties} list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Properties$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Prints \code{Properties} list to console.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-strprint"></a>}}
\subsection{Method \code{strprint()}}{
Creates a printable representation of the \code{Properties}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Properties$strprint()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{list} of properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Properties$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
