% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set_Interval_SpecialSet.R
\name{NegReals}
\alias{NegReals}
\title{Set of Negative Real Numbers}
\value{
An R6 object of class NegReals.
}
\description{
The mathematical set of negative real numbers, defined as the union of the set of negative rationals and negative irrationals. i.e. \deqn{I^- \cup Q^-}{I- U Q-} where \eqn{I^-}{I-} is the set of negative irrationals and \eqn{Q^-}{Q-} is the set of negative rationals.
}
\section{Constructor}{
 NegReals$new(zero = FALSE)
}

\section{Constructor Arguments}{

\tabular{lll}{
\strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
\code{zero = FALSE} \tab logical \tab If TRUE, zero is included in the set. \cr

}
}

\section{Public Fields}{

\tabular{ll}{
\strong{Field} \tab \strong{Link} \cr

\code{class} \tab \link{class} \cr
\code{elements} \tab \link{elements} \cr
\code{length} \tab \link{length} \cr
\code{lower} \tab \link{lower} \cr
\code{upper} \tab \link{upper} \cr
\code{max} \tab \link{max} \cr
\code{min} \tab \link{min} \cr
\code{range} \tab \link{range} \cr
\code{properties} \tab \link{properties} \cr
\code{traits} \tab \link{traits} \cr
\code{type} \tab \link{type} \cr
\code{universe} \tab \link{universe}
}
}

\section{Public Methods}{

\tabular{ll}{
\strong{Interval Methods} \tab \strong{Link} \cr
isSubinterval(x, proper = FALSE, all = FALSE) \tab \link{isSubinterval} \cr
\tab \cr \tab \cr \tab \cr

\strong{Comparison Methods} \tab \strong{Link} \cr
\code{contains(x, all = FALSE, bound = NULL)} \tab \link{contains} \cr
\code{equals(x, all = FALSE)} \tab \link{equals} \cr
\code{isSubset(x, proper = FALSE, all = FALSE)} \tab \link{isSubset} \cr
\tab \cr \tab \cr \tab \cr
\strong{Representation Methods} \tab \strong{Link} \cr
\code{strprint(n = 2)} \tab \link{strprint} \cr
\code{print(n = 2)} \tab \link{print} \cr
\code{summary(n = 2)} \tab \link{summary} \cr
}
}

\examples{
NegReals$new()
}
\seealso{
\link{listSpecialSets}

Other SpecialSets: 
\code{\link{Complex}},
\code{\link{ExtendedReals}},
\code{\link{Integers}},
\code{\link{Naturals}},
\code{\link{NegIntegers}},
\code{\link{NegRationals}},
\code{\link{PosIntegers}},
\code{\link{PosNaturals}},
\code{\link{PosRationals}},
\code{\link{PosReals}},
\code{\link{Rationals}},
\code{\link{Reals}}
}
\concept{SpecialSets}
