% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set_FuzzySet.R
\name{membership}
\alias{membership}
\title{Get Membership of Element in FuzzySet}
\arguments{
\item{element}{element or list of element in the \code{set}, if NULL returns membership of all elements}
}
\value{
Value, or vector of values, in [0, 1]
}
\description{
Returns the membership, i.e. value in [0, 1], of either the given element(s)
or all elements in the fuzzy set.
}
\details{
For \code{FuzzySet}s this is straightforward and returns the membership of the given element(s),
however in \code{FuzzyTuple}s when an element may be duplicated, the function returns the membership of
all instances of the element.
}
\section{R6 Usage}{
 $membership(element = NULL)
}

\examples{
f = FuzzySet$new(1, 0.1, 2, 0.5, 3, 1)
f$membership()
f$membership(2)
}
