% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_noise_params.R
\name{as_noise_params}
\alias{as_noise_params}
\title{Load noise parameters}
\usage{
as_noise_params(data, antigen_isos = NULL)
}
\arguments{
\item{data}{a \code{\link[=data.frame]{data.frame()}} or \link[tibble:tbl_df-class]{tibble::tbl_df}}

\item{antigen_isos}{\code{\link[=character]{character()}} vector of antigen isotypes
to be used in analyses}
}
\value{
a \code{noise_params} object (a \link[tibble:tbl_df-class]{tibble::tbl_df} with
extra attribute \code{antigen_isos})
}
\description{
Load noise parameters
}
\examples{
library(magrittr)
noise_data <-
  serocalculator_example("example_noise_params.csv") \%>\%
  read.csv() \%>\%
  as_noise_params()

print(noise_data)

}
