% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ErrToM.R
\name{ErrToM}
\alias{ErrToM}
\title{Generate Genotyping Error Matrix}
\usage{
ErrToM(Err = NA, flavour = "version2.0", Return = "matrix")
}
\arguments{
\item{Err}{estimated genotyping error rate, as a single number or 3x3 or 4x4
matrix. If a single number, an error model is used that aims to deal with
scoring errors typical for SNP arrays. If a matrix, this should be the
probability of observed genotype (columns) conditional on actual genotype
(rows). Each row must therefore sum to 1. If \code{Return='function'}, this
may be \code{NA}.}

\item{flavour}{matrix-generating function, or one of 'version2.0',
'version1.3' (='SNPchip'), 'version1.1' (='version111'), referring to the
sequoia version in which it was used as default. Ignored if \code{Err} is a
matrix and \code{Return='matrix'} (in which case the matrix will only be
checked for validity).}

\item{Return}{output, 'matrix' (always 3x3) or 'function'.}
}
\value{
Either a 3x3 matrix, or a function generating a 3x3 matrix.
}
\description{
Generate a matrix with the probabilities of observed genotypes
  (columns) conditional on actual genotypes (rows), or return a function to
  generate such matrices (using a single value Err as input to that
 function).
}
\details{
By default (\code{flavour} = "SNPchip"), \code{Err} is interpreted
  as a locus-level error rate (rather than allele-level), and equals the
  probability that an actual heterozygote is observed as either homozygote
  (i.e., the probability that it is observed as AA = probability that
  observed as aa = \code{Err}/2). The probability that one homozygote is
  observed as the other is (\code{Err}/2\eqn{)^2}.

The inbuilt 'flavours' correspond to the presumed and simulated error
structures, which have changed with sequoia versions. The most appropriate
error structure will depend on the genotyping platform; 'version0.9' and
'version1.1' were inspired by SNP array genotyping while 'version1.3' and
'version2.0' are intended to be more general.

Pr(observed genotype (columns) | actual genotype (rows)):

\emph{version2.0:}
\tabular{lccc}{
    \tab \strong{0} \tab \strong{1} \tab \strong{2} \cr
 \strong{0}  \tab \eqn{(1-E/2)^2} \tab \eqn{E(1-E/2)} \tab \eqn{(E/2)^2} \cr
 \strong{1}  \tab \eqn{E/2}       \tab \eqn{1-E}      \tab \eqn{E/2}    \cr
 \strong{2}  \tab \eqn{(E/2)^2}   \tab \eqn{E(1-E/2)} \tab \eqn{(1-E/2)^2} \cr
}

\emph{version1.3}
\tabular{lccc}{
    \tab \strong{0} \tab \strong{1} \tab \strong{2} \cr
 \strong{0}  \tab \eqn{1-E-(E/2)^2} \tab \eqn{E} \tab \eqn{(E/2)^2} \cr
 \strong{1}  \tab \eqn{E/2}       \tab \eqn{1-E}      \tab \eqn{E/2}    \cr
 \strong{2}  \tab \eqn{(E/2)^2}   \tab \eqn{E} \tab \eqn{1-E-(E/2)^2} \cr
}

\emph{version1.1}
\tabular{lccc}{
    \tab \strong{0} \tab \strong{1} \tab \strong{2} \cr
 \strong{0}  \tab \eqn{1-E} \tab \eqn{E/2} \tab \eqn{E/2} \cr
 \strong{1}  \tab \eqn{E/2}       \tab \eqn{1-E}      \tab \eqn{E/2}    \cr
 \strong{2}  \tab \eqn{E/2}   \tab \eqn{E/2} \tab \eqn{1-E} \cr
}

\emph{version0.9} (not recommended)
\tabular{lccc}{
    \tab \strong{0} \tab \strong{1} \tab \strong{2} \cr
 \strong{0}  \tab \eqn{1-E} \tab \eqn{E} \tab \eqn{0} \cr
 \strong{1}  \tab \eqn{E/2}       \tab \eqn{1-E}      \tab \eqn{E/2}    \cr
 \strong{2}  \tab \eqn{0}   \tab \eqn{E} \tab \eqn{1-E} \cr
}
}
