% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequoia_F90wrappers.R
\name{SeqDup}
\alias{SeqDup}
\title{Check data for duplicates.}
\usage{
SeqDup(Specs = NULL, GenoM = NULL, LhIN = NULL, quiet = FALSE)
}
\arguments{
\item{Specs}{The named vector with parameter values}

\item{GenoM}{matrix with genotype data, size nInd x nSnp, used if
Specs["GenotypeFilename"]=="USEMATRIX".}

\item{LhIN}{life history data}

\item{quiet}{suppress messages}
}
\value{
A list with one or more of the following elements:
\item{DupGenoID}{Dataframe, rownumbers of duplicated IDs in genotype file.
  Please do remove or relabel these to avoid downstream confusion.}
\item{DupGenotype}{Dataframe, duplicated genotypes (with or without
  identical IDs). The specified number of maximum mismatches is allowed,
  and this dataframe may include pairs of closely related individuals.}
\item{DupLifeHistID}{Dataframe, rownumbers of duplicated IDs in life
  history file}
\item{NoLH}{Vector, IDs (in genotype file) for which no life history data is
 provided}

dataframe with the numbers of duplicated genotypes, duplicated IDs in the genotype file, number of duplicated IDs in the life history file, and number of individuals with unknown sex.
}
\description{
Check the genotype and life history files for duplicate IDs (not permitted)
and duplicated genotypes (not advised), and count how many individuals in
the genotype file are included in the life history file (permitted).
}
\details{
The filenames are taken from the SequioiaSpecs text file, generated by
\code{\link{SeqPrep}}. The order of IDs in the genotype and life history file
is not required to be identical, and not all individuals in the genotype file
are required to be in the life history file.
}

