% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{seqmissimplic}
\alias{seqmissimplic}
\title{Identification and visualization of states that best characterize sequences
with missing data}
\usage{
seqmissimplic(data, var = NULL, ...)
}
\arguments{
\item{data}{a data frame where missing data are coded as \code{NA} or 
a state sequence object built with \link[TraMineR]{seqdef} function}

\item{var}{the list of columns containing the trajectories. 
Default is NULL, i.e. all the columns.}

\item{...}{parameters to be passed to the \link[TraMineRextras]{seqimplic}
function}
}
\value{
returns a \code{seqimplic} object that can be plotted and printed.
}
\description{
Function based on the \link[TraMineRextras]{seqimplic}. 
Identification and visualization of the states that best characterize the 
sequence with missing data vs. the sequences without missing data at each 
position (time point). See the \link[TraMineRextras]{seqimplic} help 
for more details on how it works.
}
\examples{

# For illustration purpose, we simulate missing data on the mvad dataset,
# available in the TraMineR package. The state "joblessness" state has a 
# higher probability of triggering a missing gap

\dontrun{
data(mvad, package = "TraMineR")
mvad.miss <- seqaddNA(mvad, var = 17:86, states.high = "joblessness")

# The states that best characterize sequences with missing data
implic <- seqmissimplic(mvad.miss, var = 17:86)

# Visualization of the results
plot(implic)
}

}
\author{
Kevin Emery
}
