% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_to_sc.R
\name{mc_to_sc}
\alias{mc_to_sc}
\title{Transform Multichannel Hidden Markov Model to Single Channel Representation}
\usage{
mc_to_sc(model, combine_missing = TRUE, all_combinations = FALSE)
}
\arguments{
\item{model}{Object of class \code{hmm} or \code{mhmm}.}

\item{combine_missing}{Controls whether combined states of observations are
coded missing (\code{NA}) if some of the channels include missing information.
Defaults to \code{TRUE}.}

\item{all_combinations}{Controls whether all possible combinations of
observed states are included in the single channel representation or only
combinations that are found in the data. Defaults to \code{FALSE}, i.e.
only actual observations are included.}
}
\description{
Transforms data and parameters of multichannel model to single channel model.
Observed states (symbols) are combined and parameters multiplied across the 
channels.
}
\details{
Note that in case of no missing observations, the log-likelihood of the original 
and transformed models are identical but 
the AIC and BIC can be different as the model attributes \code{nobs} and 
\code{df} are recomputed based on the single channel representation.
}
\examples{
# Loading a hidden Markov model of the biofam data (hmm object)
data(hmm_biofam)
logLik(hmm_biofam)
sc <- mc_to_sc(hmm_biofam)
logLik(sc)
}
\seealso{
\code{\link{build_hmm}} and \code{\link{fit_model}} for building and
  fitting Hidden Markov models; and \code{\link{hmm_biofam}} for information on
  the model used in the example;.
}

