% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_key.R
\name{as_key}
\alias{as_key}
\alias{update_key}
\alias{update_polarity_table}
\alias{update_valence_shifter_table}
\alias{is_key}
\title{Create/Manipulate Hash Keys}
\usage{
as_key(x, comparison = lexicon::hash_valence_shifters,
  sentiment = TRUE, ...)

update_key(key, drop = NULL, x = NULL,
  comparison = lexicon::hash_valence_shifters, sentiment = FALSE, ...)

update_polarity_table(key, drop = NULL, x = NULL,
  comparison = lexicon::hash_valence_shifters, sentiment = FALSE, ...)

update_valence_shifter_table(key, drop = NULL, x = NULL,
  comparison = lexicon::hash_sentiment_jockers_rinker,
  sentiment = FALSE, ...)

is_key(key, sentiment = TRUE)
}
\arguments{
\item{x}{A \code{\link[base]{data.frame}} with the first column containing
polarized words and the second containing polarity values.}

\item{comparison}{A \code{\link[base]{data.frame}} to compare to \code{x}.
If elements in \code{x}'s column 1 matches \code{comparison}'s column 1 the
accompanying row will be removed from \code{x}.  This is useful to ensure
\code{polarity_dt} words are not also found in \code{valence_shifters_dt} in
\code{\link[sentimentr]{sentiment}}.  Use \code{comparison = NULL} to skip
this comparison.}

\item{sentiment}{logical.  If \code{TRUE} checking expects column 2 of the
input keys/\code{\link[base]{data.frame}} are expected to be numeric.}

\item{key}{A \pkg{sentimentr} hash key.}

\item{drop}{A vector of terms to drop.}

\item{\ldots}{ignored.}
}
\value{
Returns a \pkg{data.table} object that can be used as a hash key.
}
\description{
\code{as_key} - Create your own hash keys from a data frame for use in key
arguments such as \code{polarity_dt} in the \code{sentiment} function.

\code{update_key} - Add/remove terms to a current key.

\code{update_polarity_table} - Wrapper for \code{update_key} specifically for
updating polarity tables.

\code{update_valence_shifter_table} - Wrapper for \code{update_key} 
specifically for updating valence shifter tables.

\code{is_key} - Logical check if an object is a key.
}
\details{
For updating keys via \code{update_key} note that a 
\code{polarity_dt} and \code{valence_shifters_dt} are the primary dictionary 
keys used in the \pkg{sentimentr} package.  The \code{polarity_dt} takes a 
2 column \code{data.frame} (named x and y) with the first column being 
character and containing the words and the second column being numeric values
that are positive or negative.  \code{valence_shifters_dt} takes a 2 column 
\code{data.frame} (named x and y) with the first column being character and 
containing the words and the second column being integer corresponding to:
(1) negators, (2) amplifiers, (3) de-amplifiers, and (4) dversative 
conjunctions (i.e., 'but', 'however', and 'although').  Also, note that if 
you are updating a \code{valence_shifters_dt} you need an appropriate 
\code{comparison}; most likely, \code{comparison = sentimentr::polarity_dt}.
}
\examples{
key <- data.frame(
    words = sample(letters),
    polarity = rnorm(26),
    stringsAsFactors = FALSE
)

(mykey <- as_key(key))

## Looking up values
mykey[c("a", "k")][[2]]

## Drop terms from key
update_key(mykey, drop = c("f", "h"))

## Add terms to key
update_key(mykey, x = data.frame(x = c("dog", "cat"), y = c(1, -1)))

## Add terms & drop to/from a key
update_key(mykey, drop = c("f", "h"), x = data.frame(x = c("dog", "cat"), y = c(1, -1)))

## Explicity key type (wrapper for `update_key` for sentiment table.
## See `update_valence_shifter_table` a corresponding valence shifter updater.
library(lexicon)
updated_hash_sentiment <- sentimentr:::update_polarity_table(lexicon::hash_sentiment_huliu,
    x = data.frame(
        words = c('frickin', 'hairy'),
        polarity = c(-1, -1),
        stringsAsFactors = FALSE
    )
)

## Checking if you have a key
is_key(mykey)
is_key(key)
is_key(mtcars)
is_key(update_key(mykey, drop = c("f", "h")))

## Using syuzhet's sentiment lexicons
\dontrun{
library(syuzhet)
as_key(syuzhet:::bing)
as_key(syuzhet:::afinn)
as_key(syuzhet:::syuzhet_dict)

sentiment(gsub("Sam-I-am", "Sam I am", sam_i_am), as_key(syuzhet:::bing))
}

## Using 2 vectors of words
\dontrun{
install.packages("tm.lexicon.GeneralInquirer", repos="http://datacube.wu.ac.at", type="source")
require("tm.lexicon.GeneralInquirer")

positive <- terms_in_General_Inquirer_categories("Positiv")
negative <- terms_in_General_Inquirer_categories("Negativ")

geninq <- data.frame(
    x = c(positive, negative),
    y = c(rep(1, length(positive)), rep(-1, length(negative))),
    stringsAsFactors = FALSE
) \%>\%
    as_key()

geninq_pol <- with(presidential_debates_2012,
    sentiment_by(dialogue,
    person,
    polarity_dt = geninq
))

geninq_pol \%>\% plot()
}
}
\keyword{hash}
\keyword{key}
\keyword{lookup}
