% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_sentiment.R
\name{validate_sentiment}
\alias{validate_sentiment}
\title{Validate Sentiment Score Sign Against Known Results}
\usage{
validate_sentiment(predicted, actual, ...)
}
\arguments{
\item{predicted}{A numeric vector of predicted sentiment scores or a 
\pkg{sentimentr} object that returns sentiment scores.}

\item{actual}{A numeric vector of known sentiment ratings.}

\item{\ldots}{ignored.}
}
\description{
Provides a miulticlass macroaverage/microaverage of precision, recall, 
accuracy, and F-score for the sign of the predicted sentiment against known 
sentiment scores. Macroaveraging allows every class to have an equal say.  
Microaveraging gives larger say to larger classes.
}
\examples{
actual <- c(1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, 1,-1)
predicted <- c(1, 0, 1, -1, 1, 0, -1, -1, -1, -1, 0, 1,-1)
validate_sentiment(actual, predicted)

scores <- cannon_reviews$opinion.score
mod <- sentiment_by(cannon_reviews$review)

validate_sentiment(mod$ave_sentiment, scores)
validate_sentiment(mod, scores)

x <- validate_sentiment(mod, actual)
attributes(x)$confusion_matrix
attributes(x)$class_confusion_matrices
attributes(x)$macro_stats
}
\references{
\url{https://www.youtube.com/watch?v=OwwdYHWRB5E&index=31&list=PL6397E4B26D00A269}
}
