% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars_to.R
\name{vars_to}
\alias{vars_to}
\title{Computation of VARS Total order index (VARS-TO)}
\usage{
vars_to(Y, star.centers, params, h, method = "all.step")
}
\arguments{
\item{Y}{A numeric vector with the model output obtained from the matrix created with
\code{\link{vars_matrices}}.}

\item{star.centers}{Positive integer, number of star centers.}

\item{params}{Character vector with the name of the model inputs.}

\item{h}{Distance between pairs.}

\item{method}{Type of computation. If \code{method = "all.step"}, all pairs of points with values
\eqn{\Delta h, 2\Delta h, 3\Delta h,...} are used in each dimension. If \code{method = "one.step"},
only the pairs \eqn{\Delta h} away are used. The default is \code{method = "all.step"}.}
}
\value{
A \code{data.table} with the VARS-TO indices of each parameter.
}
\description{
It computes VARS-TO following \insertCite{Razavi2016a;textual}{sensobol}.
}
\details{
VARS is based on variogram analysis to characterize the spatial structure and variability
of a given model output across the input space \insertCite{Razavi2016a}{sensobol}. Variance-
based total-order effects can be computed as by-products of the VARS framework. The total-order index
is related to the variogram \eqn{\gamma(.)} and co-variogram \eqn{C(.)} functions by the
following equation:

\deqn{T_i = \frac{\gamma (h_i) + E \left [C_{\mathbf{x}_{\sim i}} (h_i) \right]}{\hat{V}(y)} }

where \eqn{x^*_{\sim i}} is a vector of all \eqn{k} factors except \eqn{x_i}.
}
\examples{
# Define settings
star.centers <- 10; params <- paste("X", 1:3, sep = ""); h <- 0.1

# Create STAR-VARS
mat <- vars_matrices(star.centers = star.centers, params = params, h = h)

# Run model
y <- sensobol::ishigami_Fun(mat)

# Compute VARS-TO
ind <- vars_to(Y = y, star.centers = star.centers, params = params, h = h)
}
\references{
\insertAllCited{}
}
