% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence_plot.R
\name{influence_plot}
\alias{influence_plot}
\alias{gcd_plot}
\alias{md_plot}
\alias{gcd_gof_plot}
\alias{gcd_gof_md_plot}
\title{Plots of Influence Measures}
\usage{
gcd_plot(
  influence_out,
  cutoff_gcd = NULL,
  largest_gcd = 1,
  point_aes = list(),
  vline_aes = list(),
  cutoff_line_aes = list(),
  case_label_aes = list()
)

md_plot(
  influence_out,
  cutoff_md = FALSE,
  cutoff_md_qchisq = 0.975,
  largest_md = 1,
  point_aes = list(),
  vline_aes = list(),
  cutoff_line_aes = list(),
  case_label_aes = list()
)

gcd_gof_plot(
  influence_out,
  fit_measure,
  cutoff_gcd = NULL,
  cutoff_fit_measure = NULL,
  largest_gcd = 1,
  largest_fit_measure = 1,
  point_aes = list(),
  hline_aes = list(),
  cutoff_line_gcd_aes = list(),
  cutoff_line_fit_measures_aes = list(),
  case_label_aes = list()
)

gcd_gof_md_plot(
  influence_out,
  fit_measure,
  cutoff_md = FALSE,
  cutoff_fit_measure = NULL,
  circle_size = 2,
  cutoff_md_qchisq = 0.975,
  cutoff_gcd = NULL,
  largest_gcd = 1,
  largest_md = 1,
  largest_fit_measure = 1,
  point_aes = list(),
  hline_aes = list(),
  cutoff_line_md_aes = list(),
  cutoff_line_gcd_aes = list(),
  cutoff_line_fit_measures_aes = list(),
  case_label_aes = list()
)
}
\arguments{
\item{influence_out}{The output from \code{\link[=influence_stat]{influence_stat()}}.}

\item{cutoff_gcd}{Cases with generalized Cook's distance or
approximate generalized Cook's distance larger
than this value will be labeled. Default is \code{NULL}. If \code{NULL}, no
cutoff line will be drawn.}

\item{largest_gcd}{The number of cases with the largest generalized
Cook's distance or approximate generalized Cook's distance
to be labelled. Default is 1. If not an integer, it
will be rounded to the nearest integer.}

\item{point_aes}{A named list of
arguments to be passed to
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} to modify how
to draw the points. Default is
\code{list()} and internal default
settings will be used.}

\item{vline_aes}{A named list of
arguments to be passed to
\code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}} to modify how
to draw the line for each case
in the index plot. Default is
\code{list()} and internal default
settings will be used.}

\item{cutoff_line_aes}{A named list
of arguments to be passed to
\code{\link[ggplot2:geom_abline]{ggplot2::geom_vline()}} or
\code{\link[ggplot2:geom_abline]{ggplot2::geom_hline()}} to modify how
to draw the line for user cutoff
value. Default is \code{list()}
and internal default settings will be
used.}

\item{case_label_aes}{A named list of
arguments to be passed to
\code{\link[ggrepel:geom_text_repel]{ggrepel::geom_label_repel()}} to
modify how to draw the labels for
cases marked (based on arguments
such as \code{cutoff_gcd} or \code{largest_gcd}).
Default is \code{list()} and internal
default settings will be used.}

\item{cutoff_md}{Cases with Mahalanobis distance larger than this
value will be labeled. If it is \code{TRUE}, the (\code{cutoff_md_qchisq} x
100)th percentile of the chi-square distribution with the degrees
of freedom equal to the number of variables will be used.  Default
is \code{FALSE}, no cutoff value.}

\item{cutoff_md_qchisq}{This value multiplied by 100 is the
percentile to be used for labeling case based on Mahalanobis
distance. Default is .975.}

\item{largest_md}{The number of cases with the largest Mahalanobis
distance to be labelled. Default is 1. If not an integer, it will
be rounded to the nearest integer.}

\item{fit_measure}{The fit measure to be used in a
plot. Use the name in the \code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}} function. No
default value.}

\item{cutoff_fit_measure}{Cases with \code{fit_measure} larger than
this cutoff in magnitude will be labeled. No default value and
must be specified.}

\item{largest_fit_measure}{The number of cases with the largest
selected fit measure change in magnitude to be labelled. Default is
\enumerate{
\item If not an integer, it will be rounded to the nearest integer.
}}

\item{hline_aes}{A named list of
arguments to be passed to
\code{\link[ggplot2:geom_abline]{ggplot2::geom_hline()}} to modify how
to draw the horizontal line for zero
case influence. Default is \code{list()}
and internal default settings will be
used.}

\item{cutoff_line_gcd_aes}{Similar
to \code{cutoff_line_aes} but control
the line for the cutoff value of
\emph{gCD}.}

\item{cutoff_line_fit_measures_aes}{Similar
to \code{cutoff_line_aes} but control
the line for the cutoff value of
the selected fit measure.}

\item{circle_size}{The size of the largest circle when the size
of a circle is controlled by a statistic.}

\item{cutoff_line_md_aes}{Similar
to \code{cutoff_line_aes} but control
the line for the cutoff value of
the Mahalanobis distance.}
}
\value{
A \link{ggplot2} plot. Plotted by default. If assigned to a variable
or called inside a function, it will not be plotted. Use \code{\link[=plot]{plot()}} to
plot it.
}
\description{
Gets an \code{\link[=influence_stat]{influence_stat()}} output and plots selected
statistics.
}
\details{
The output of \code{\link[=influence_stat]{influence_stat()}} is simply a matrix.
Therefore, these functions will work for any matrix provided. Row
number will be used on the x-axis if applicable. However, case
identification values in the output from \code{\link[=influence_stat]{influence_stat()}} will
be used for labeling individual cases.

The default settings for the plots
should be good enough for diagnostic
purpose. If so desired, users can
use the \verb{*_aes} arguments to nearly
fully customize all the major
elements of the plots, as they would
do for building a \link{ggplot2} plot.
}
\section{Functions}{
\itemize{
\item \code{gcd_plot()}: Index plot of generalized Cook's distance.

\item \code{md_plot()}: Index plot of Mahalanobis distance.

\item \code{gcd_gof_plot()}: Plot the case influence of the selected fit
measure against generalized Cook's distance.

\item \code{gcd_gof_md_plot()}: Bubble plot of the case influence of the selected
fit measure against Mahalanobis distance, with the size of a bubble
determined by generalized Cook's distance.

}}
\examples{
library(lavaan)
dat <- pa_dat
# The model
mod <-
"
m1 ~ a1 * iv1 + a2 * iv2
dv ~ b * m1
a1b := a1 * b
a2b := a2 * b
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)
# Fit the model n times. Each time with one case removed.
# For illustration, do this only for selected cases.
fit_rerun <- lavaan_rerun(fit, parallel = FALSE,
                          to_rerun = 1:10)
# Get all default influence stats
out <- influence_stat(fit_rerun)
head(out)

# Plot generalized Cook's distance. Label the 3 cases with the largest distances.
gcd_plot(out, largest_gcd = 3)

# Plot Mahalanobis distance. Label the 3 cases with the largest distances.
md_plot(out, largest_md = 3)

# Plot case influence on model chi-square against generalized Cook's distance.
# Label the 3 cases with the largest absolute influence.
# Label the 3 cases with the largest generalized Cook's distance.
gcd_gof_plot(out, fit_measure = "chisq", largest_gcd = 3,
             largest_fit_measure = 3)

# Plot case influence on model chi-square against Mahalanobis distance.
# Size of bubble determined by generalized Cook's distance.
# Label the 3 cases with the largest absolute influence.
# Label the 3 cases with the largest Mahalanobis distance.
# Label the 3 cases with the largest generalized Cook's distance.

gcd_gof_md_plot(out, fit_measure = "chisq",
                     largest_gcd = 3,
                     largest_fit_measure = 3,
                     largest_md = 3,
                     circle_size = 10)

# Use the approximate method that does not require refitting the model.

# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)
out <- influence_stat(fit)
head(out)

# Plot approximate generalized Cook's distance.
# Label the 3 cases with the largest values.
gcd_plot(out, largest_gcd = 3)

# Plot Mahalanobis distance.
# Label the 3 cases with the largest values.
md_plot(out, largest_md = 3)

# Plot approximate case influence on model chi-square against
# approximate generalized Cook's distance.
# Label the 3 cases with the largest absolute approximate case influence.
# Label the 3 cases with the largest approximate generalized Cook's distance.
gcd_gof_plot(out, fit_measure = "chisq", largest_gcd = 3,
             largest_fit_measure = 3)

# Plot approximate case influence on model chi-square against Mahalanobis distance.
# The size of a bubble determined by approximate generalized Cook's distance.
# Label the 3 cases with the largest absolute approximate case influence.
# Label the 3 cases with the largest Mahalanobis distance.
# Label the 3 cases with the largest approximate generalized Cook's distance.

gcd_gof_md_plot(out, fit_measure = "chisq",
                     largest_gcd = 3,
                     largest_fit_measure = 3,
                     largest_md = 3,
                     circle_size = 10)

# Customize elements in the plot.
# For example, change the color and shape of the points.

gcd_gof_plot(out, fit_measure = "chisq", largest_gcd = 3,
             largest_fit_measure = 3,
             point_aes = list(shape = 3, color = "red"))

}
\references{
Pek, J., & MacCallum, R. (2011). Sensitivity analysis
in structural equation models: Cases and their influence.
\emph{Multivariate Behavioral Research, 46}(2), 202-228.
doi:10.1080/00273171.2011.561068
}
\seealso{
\code{\link[=influence_stat]{influence_stat()}}.
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}.
}
