% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahalanobis_rerun.R
\name{mahalanobis_rerun}
\alias{mahalanobis_rerun}
\title{Mahalanobis Distance on All Observed Variables}
\usage{
mahalanobis_rerun(
  fit,
  emNorm_arg = list(estimate.worst = FALSE, criterion = 1e-06)
)
}
\arguments{
\item{fit}{It can be the output from \code{lavaan}, such as
\code{\link[lavaan:cfa]{lavaan::cfa()}} and \code{\link[lavaan:sem]{lavaan::sem()}}, or the output from
\code{\link[=lavaan_rerun]{lavaan_rerun()}}.}

\item{emNorm_arg}{A list of argument for
\code{\link[norm2:emNorm]{norm2::emNorm()}}. Default is
\code{list(estimate.worst = FALSE, criterion = 1e-6)}.
Ignored if there is no missing data on the exogenous observed
variables.}
}
\value{
A one-column matrix (a column vector) of the Mahalanobis
distance for each case. The row names are the case identification
values used in \code{\link[=lavaan_rerun]{lavaan_rerun()}}.
}
\description{
Computes the Mahalanobis distance for each case on all
observed variables in a model.
}
\details{
\code{\link[=mahalanobis_rerun]{mahalanobis_rerun()}} gets a \code{\link[=lavaan_rerun]{lavaan_rerun()}} or
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} output and computes the Mahalanobis distance for
each case on all observed variables.

If there are no missing values, \code{\link[stats:mahalanobis]{stats::mahalanobis()}} will be used
to compute the Mahalanobis distance.

If there are missing values on the observed predictors, the means
and variance-covariance matrices will be estimated by maximum
likelihood using \code{\link[norm2:emNorm]{norm2::emNorm()}}. The estimates will be passed
to \code{\link[modi:MDmiss]{modi::MDmiss()}} to compute the Mahalanobis distance.

Currently it only supports single-group models.
}
\examples{
library(lavaan)
dat <- pa_dat
# The model
mod <-
"
m1 ~ a1 * iv1 + a2 * iv2
dv ~ b * m1
a1b := a1 * b
a2b := a2 * b
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)
# Fit the model n times. Each time with one case removed.
# For illustration, do this only for selected cases.
fit_rerun <- lavaan_rerun(fit, parallel = FALSE,
                          to_rerun = 1:10)
# Compute the Mahalanobis distance for each case
out <- mahalanobis_rerun(fit_rerun)
# Results excluding a case, for the first few cases
head(out)
# Compute the Mahalanobis distance using stats::mahalanobis()
md1 <- stats::mahalanobis(dat, colMeans(dat), stats::cov(dat))
# Compare the results
head(md1)

# A CFA model

dat <- cfa_dat
mod <-
"
f1 =~  x1 + x2 + x3
f2 =~  x4 + x5 + x6
f1 ~~ f2
"
# Fit the model
fit <- lavaan::cfa(mod, dat)

fit_rerun <- lavaan_rerun(fit, parallel = FALSE,
                          to_rerun = 1:10)
mahalanobis_rerun(fit_rerun)

# A latent variable model

dat <- sem_dat
mod <-
"
f1 =~  x1 + x2 + x3
f2 =~  x4 + x5 + x6
f3 =~  x7 + x8 + x9
f2 ~   a * f1
f3 ~   b * f2
ab := a * b
"
# Fit the model
fit <- lavaan::cfa(mod, dat)

fit_rerun <- lavaan_rerun(fit, parallel = FALSE,
                          to_rerun = 1:10)
mahalanobis_rerun(fit_rerun)


}
\references{
Mahalanobis, P. C. (1936). On the generalized distance
in statistics. \emph{Proceedings of the National Institute of Science
of India, 2}, 49-55.
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}.
}
