% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMI-methods.R
\docType{class}
\name{lavaan.mi-class}
\alias{lavaan.mi-class}
\alias{show,lavaan.mi-method}
\alias{summary,lavaan.mi-method}
\alias{anova,lavaan.mi-method}
\alias{nobs,lavaan.mi-method}
\alias{coef,lavaan.mi-method}
\alias{vcov,lavaan.mi-method}
\alias{fitted,lavaan.mi-method}
\alias{fitted.values,lavaan.mi-method}
\alias{residuals,lavaan.mi-method}
\alias{resid,lavaan.mi-method}
\alias{lavaan.mi-class}
\alias{show,lavaan.mi-method}
\alias{lavaan.mi-class}
\alias{summary,lavaan.mi-method}
\alias{lavaan.mi-class}
\alias{nobs,lavaan.mi-method}
\alias{lavaan.mi-class}
\alias{coef,lavaan.mi-method}
\alias{lavaan.mi-class}
\alias{vcov,lavaan.mi-method}
\alias{lavaan.mi-class}
\alias{anova,lavaan.mi-method}
\alias{lavaan.mi-class}
\alias{fitMeasures,lavaan.mi-method}
\alias{lavaan.mi-class}
\alias{fitmeasures,lavaan.mi-method}
\alias{lavaan.mi-class}
\alias{fitted,lavaan.mi-method}
\alias{lavaan.mi-class}
\alias{fitted.values,lavaan.mi-method}
\alias{lavaan.mi-class}
\alias{residuals,lavaan.mi-method}
\alias{lavaan.mi-class}
\alias{resid,lavaan.mi-method}
\title{Class for a lavaan Model Fitted to Multiple Imputations}
\usage{
\S4method{show}{lavaan.mi}(object)

\S4method{summary}{lavaan.mi}(object, se = TRUE, ci = FALSE, level = 0.95,
  standardized = FALSE, rsquare = FALSE, fmi = FALSE, header = TRUE,
  scale.W = TRUE, asymptotic = FALSE, add.attributes = TRUE)

\S4method{nobs}{lavaan.mi}(object, total = TRUE)

\S4method{coef}{lavaan.mi}(object, type = "free", labels = TRUE)

\S4method{vcov}{lavaan.mi}(object, type = c("pooled", "between", "within",
  "ariv"), scale.W = TRUE)

\S4method{anova}{lavaan.mi}(object, h1 = NULL, test = c("D3", "D2", "D1"),
  pool.robust = FALSE, scale.W = FALSE, asymptotic = FALSE,
  constraints = NULL, indices = FALSE, baseline.model = NULL,
  method = "default", A.method = "delta", scaled.shifted = TRUE,
  H1 = TRUE, type = "Chisq")

\S4method{fitMeasures}{lavaan.mi}(object, fit.measures = "all",
  baseline.model = NULL)

\S4method{fitmeasures}{lavaan.mi}(object, fit.measures = "all",
  baseline.model = NULL)

\S4method{fitted}{lavaan.mi}(object)

\S4method{fitted.values}{lavaan.mi}(object)

\S4method{residuals}{lavaan.mi}(object, type = c("raw", "cor"))

\S4method{resid}{lavaan.mi}(object, type = c("raw", "cor"))
}
\arguments{
\item{object}{An object of class \code{lavaan.mi}}

\item{se, ci, level, standardized, rsquare, header, add.attributes}{See
\code{\link[lavaan]{parameterEstimates}}.}

\item{fmi}{\code{logical} indicating whether to include the Fraction Missing
Information (FMI) for parameter estimates in the \code{summary} output
(see \bold{Value} section).}

\item{scale.W}{\code{logical}. If \code{TRUE} (default), the \code{vcov}
method will calculate the pooled covariance matrix by scaling the
within-imputation component by the ARIV (see Enders, 2010, p. 235,
for definition and formula). Otherwise, the pooled matrix is calculated
as the weighted sum of the within-imputation and between-imputation
components (see Enders, 2010, ch. 8, for details). This in turn affects
how the \code{summary} method calcualtes its pooled standard errors, as
well as the Wald test (\code{anova(..., test = "D1")}).}

\item{asymptotic}{\code{logical}. If \code{FALSE} (typically a default, but
see \bold{Value} section for details using various methods), pooled
tests (of fit or pooled estimates) will be \emph{F} or \emph{t}
statistics with associated degrees of freedom (\emph{df}). If
\code{TRUE}, the (denominator) \emph{df} are assumed to be sufficiently
large for a \emph{t} statistic to follow a normal distribution, so it
is printed as a \emph{z} statisic; likewise, \emph{F} times its
numerator \emph{df} is printed, assumed to follow a \eqn{\chi^2}
distribution.}

\item{total}{\code{logical} (default: \code{TRUE}) indicating whether the
\code{nobs} method should return the total sample size or (if
\code{FALSE}) a vector of group sample sizes.}

\item{type}{The meaning of this argument varies depending on which method it
it used for. Find detailed descriptions in the \bold{Value} section
under \code{coef}, \code{vcov}, \code{residuals}, and \code{anova}.}

\item{labels}{\code{logical} indicating whether the \code{coef} output should
include parameter labels. Default is \code{TRUE}.}

\item{h1}{An object of class \code{lavaan.mi} in which \code{object} is
nested, so that their difference in fit can be tested using
\code{anova} (see \bold{Value} section for details).}

\item{test}{\code{character} indicating the method used to pool model-fit or
     model-comparison test statistics:
\itemize{
   \item{\code{"D3": }}{The default test (\code{"D3"}, or any of
         \code{"mr", "Meng.Rubin", "likelihood", "LRT"}) is a pooled
         likeliehood-ratio test (see Enders, 2010, ch. 8).
         \code{test = "mplus"} implies \code{"D3"} and \code{asymptotic =
         TRUE} (see Asparouhov & Muthen, 2010). When using a non-likelihood
         estimator (e.g., DWLS for categorical outcomes), \code{"D3"} is
         unavailable, so the default is changed to \code{"D2"}.}
   \item{\code{"D2": }}{Returns a pooled test statistic, as described by
         Li, Meng, Raghunathan, & Rubin (1991) and Enders (2010, chapter 8).
         Aliases include \code{"lmrr", "Li.et.al", "pooled.wald"}).}
   \item{\code{"D1": }}{Returns a Wald test calculated for constraints on
         the pooled point estimates, using the pooled covariance matrix of
         parameter estimates; see \code{\link[lavaan]{lavTestWald}} for
         details. \code{h1} is ignored when \code{test = "D1"}, and
         \code{constraints} is ignored when \code{test != "D1"}. The
         \code{scale.W} argument is passed to the \code{vcov} method (see
         \bold{Value} section for details).}
 }}

\item{pool.robust}{\code{logical}. Ignored unless \code{test = "D2"} and a
robust test was requested. If \code{pool.robust = TRUE}, the robust test
statistic is pooled, whereas \code{pool.robust = FALSE} will pool
the naive test statistic (or difference statistic) and apply the average
scale/shift parameter to it (unavailable for mean- and variance-adjusted
difference statistics, so \code{pool.robust} will be set \code{TRUE}).
If \code{test = "D2"} and \code{pool.robust = TRUE}, further options
can be passed to \code{\link[lavaan]{lavTestLRT}} (see below).}

\item{constraints}{See \code{\link[lavaan]{lavTestWald}}.}

\item{indices}{\code{logical}, or \code{character} vector naming fit indices
to be printed with test of model fit.  Ignored \code{if (!is.null(h1))}.
See description of \code{anova} in \bold{Value} section for details.}

\item{method, A.method, H1, scaled.shifted}{See \code{\link[lavaan]{lavTestLRT}}.}

\item{fit.measures, baseline.model}{See \code{\link[lavaan]{fitMeasures}}.}
}
\value{
\item{coef}{\code{signature(object = "lavaan.mi", type = "free", labels = TRUE)}:
 See \code{\linkS4class{lavaan}}. Returns the pooled point estimates (i.e.,
 averaged across imputed data sets; see Rubin, 1987).}

\item{vcov}{\code{signature(object = "lavaan.mi", scale.W = TRUE,
 type = c("pooled","between","within","ariv"))}:  By default, returns the
 pooled covariance matrix of parameter estimates (\code{type = "pooled"}),
 the within-imputations covariance matrix (\code{type = "within"}), the
 between-imputations covariance matrix (\code{type = "between"}), or the
 average relative increase in variance (\code{type = "ariv"}) due to missing
 data.}

\item{fitted.values}{\code{signature(object = "lavaan.mi")}: See
 \code{\linkS4class{lavaan}}. Returns model-implied moments, evaluated at the
 pooled point estimates.}
\item{fitted}{\code{signature(object = "lavaan.mi")}:
  alias for \code{fitted.values}}

\item{residuals}{\code{signature(object = "lavaan.mi", type = c("raw","cor"))}:
 See \code{\linkS4class{lavaan}}. By default (\code{type = "raw"}), returns
 the difference between the model-implied moments from \code{fitted.values}
 and the pooled observed moments (i.e., averaged across imputed data sets).
 Standardized residuals are also available, using Bollen's
 (\code{type = "cor"} or \code{"cor.bollen"}) or Bentler's
 (\code{type = "cor.bentler"}) formulas.}
\item{resid}{\code{signature(object = "lavaan.mi", type = c("raw","cor"))}:
 alias for \code{residuals}}

\item{nobs}{\code{signature(object = "lavaan.mi", total = TRUE)}: either
 the total (default) sample size or a vector of group sample sizes
 (\code{total = FALSE}).}

\item{anova}{\code{signature(object = "lavaan.mi", h1 = NULL,
  test = c("D3","D2","D1"), pool.robust = FALSE, scale.W = TRUE,
  asymptotic = FALSE, constraints = NULL, indices = FALSE, baseline.model = NULL,
  method = "default", A.method = "delta", H1 = TRUE, type = "Chisq")}:
  Returns a test of model fit if \code{h1} is \code{NULL}, or a test
  of the difference in fit between nested models if \code{h1} is another
  \code{lavaan.mi} object, assuming \code{object} is nested in \code{h1}. If
  \code{asymptotic}, the returned test statistic will follow a \eqn{\chi^2}
  distribution in sufficiently large samples; otherwise, it will follow an
  \emph{F} distribution. If a robust test statistic is detected in the
  \code{object} results (it is assumed the same was requested in \code{h1},
  if provided), then \code{asymptotic} will be set to \code{TRUE} and the
  pooled test statistic will be scaled using the average scaling factor (and
  average shift parameter or \emph{df}, if applicable) across imputations
  (unless \code{pool.robust = FALSE} and \code{test = "D2"}; see below).

  When \code{indices = TRUE} and \code{is.null(h1)}, popular indices of
  approximate fit (CFI, TLI/NNFI, RMSEA with CI, and SRMR) will be returned
  for \code{object}; see \code{\link[lavaan]{fitMeasures}} for more details.
  Specific indices can be requested with a \code{character} vector (any of
  \code{"mfi", "rmsea", "gammaHat", "rmr", "srmr", "cfi", "tli", "nnfi",
  "rfi", "nfi", "pnfi", "ifi", "rni"}), or all available indices will be
  returned if \code{indices = "all"}. Users can specify a custom
  \code{baseline.model}, also fit using \code{runMI}, to calculate
  incremental fit indices (e.g., CFI, TLI). If \code{baseline.model = NULL},
  the default independence model will be used.}

\item{fitMeasures}{\code{signature(object = "lavaan.mi",
  fit.measures = "all", baseline.model = NULL)}: arguments are consistent
  with lavaan's \code{\link[lavaan]{fitMeasures}}. This merely calls the
  \code{anova} method described above, with \code{indices = fit.measures}
  and \code{baseline.model = baseline.model}, and default values for the
  remaining arguments. The user has more control (e.g., over pooling methods)
  using \code{anova} directly.}
\item{fitmeasures}{alias for \code{fitMeasures}.}

\item{show}{\code{signature(object = "lavaan.mi")}: returns a message about
 convergence rates and estimation problems (if applicable) across imputed
 data sets.}

\item{summary}{\code{signature(object = "lavaan.mi", se = TRUE, ci = FALSE,
 level = .95, standardized = FALSE, rsquare = FALSE, fmi = FALSE,
 scale.W = FALSE, asymptotic = FALSE, add.attributes = TRUE)}: see
 \code{\link[lavaan]{parameterEstimates}} for details.
 By default, \code{summary} returns pooled point and \emph{SE}
 estimates, along with \emph{t} test statistics and their associated
 \emph{df} and \emph{p} values. If \code{ci = TRUE}, confidence intervales
 are returned with the specified confidence \code{level} (default 95\% CI).
 If \code{asymptotic = TRUE}, \emph{z} instead of \emph{t} tests are
 returned. \code{standardized} solution(s) can also be requested by name
 (\code{"std.lv"} or \code{"std.all"}) or both are returned with \code{TRUE}.
 \emph{R}-squared for endogenous variables can be requested, as well as the
 Fraction Missing Information (FMI) for parameter estimates. By default, the
 output will appear like \code{lavaan}'s \code{summary} output, but if
 \code{add.attributes = FALSE}, the returned \code{data.frame} will resemble
 the \code{parameterEstimates} output. The \code{scale.W} argument is
 passed to \code{vcov} (see description above).}
}
\description{
This class extends the \code{\linkS4class{lavaanList}} class, created by
fitting a lavaan model to a list of data sets. In this case, the list of
data sets are multiple imputations of missing data.
}
\section{Slots}{

\describe{
\item{\code{coefList}}{\code{list} of estimated coefficients in matrix format (one
per imputation) as output by \code{\link[lavaan]{lavInspect}(fit, "est")}}

\item{\code{GLIST}}{pooled \code{list} of coefficients in GLIST format}

\item{\code{miList}}{\code{list} of modification indices output by
\code{\link[lavaan]{modindices}}}

\item{\code{seed}}{\code{integer} seed set before running imputations}

\item{\code{lavListCall}}{call to \code{\link[lavaan]{lavaanList}} used to fit the
model to the list of imputed data sets in \code{@DataList}, stored as a
\code{list} of arguments}

\item{\code{imputeCall}}{call to imputation function (if used), stored as a
\code{list} of arguments}

\item{\code{convergence}}{\code{list} of \code{logical} vectors indicating whether,
for each imputed data set, (1) the model converged on a solution, (2)
\emph{SE}s could be calculated, (3) the (residual) covariance matrix of
latent variables (\eqn{\Psi}) is non-positive-definite, and (4) the residual
covariance matrix of observed variables (\eqn{\Theta}) is
non-positive-definite.}

\item{\code{lavaanList_slots}}{All remaining slots are from
\code{\linkS4class{lavaanList}}, but \code{\link{runMI}} only populates a
subset of the \code{list} slots, two of them with custom information:}

\item{\code{DataList}}{The \code{list} of imputed data sets}

\item{\code{SampleStatsList}}{List of output from
\code{\link[lavaan]{lavInspect}(fit, "sampstat")} applied to each fitted
model}

\item{\code{ParTableList}}{See \code{\linkS4class{lavaanList}}}

\item{\code{vcovList}}{See \code{\linkS4class{lavaanList}}}

\item{\code{testList}}{See \code{\linkS4class{lavaanList}}}
}}

\section{Objects from the Class}{
 See the \code{\link{runMI}} function for
details. Wrapper functions include \code{\link{lavaan.mi}},
\code{\link{cfa.mi}}, \code{\link{sem.mi}}, and \code{\link{growth.mi}}.
}

\examples{

## See ?runMI help page

}
\references{
Asparouhov, T., & Muthen, B. (2010). \emph{Chi-square statistics
with multiple imputation}. Technical Report. Retrieved from
\url{www.statmodel.com}

Enders, C. K. (2010). \emph{Applied missing data analysis}. New York, NY:
Guilford.

Li, K.-H., Meng, X.-L., Raghunathan, T. E., & Rubin, D. B. (1991).
Significance levels from repeated \emph{p}-values with multiply-imputed data.
\emph{Statistica Sinica, 1}(1), 65--92. Retrieved from
\url{http://www.jstor.org/stable/24303994}

Meng, X.-L., & Rubin, D. B. (1992). Performing likelihood ratio tests with
multiply-imputed data sets. \emph{Biometrika, 79}(1), 103--111. Retrieved
from \url{http://www.jstor.org/stable/2337151}

Rubin, D. B. (1987). \emph{Multiple imputation for nonresponse in surveys}.
New York, NY: Wiley.
}
\author{
Terrence D. Jorgensen (University of Amsterdam;
\email{TJorgensen314@gmail.com})
}
