% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareFit.R
\docType{class}
\name{FitDiff-class}
\alias{FitDiff-class}
\alias{show,FitDiff-method}
\alias{summary,FitDiff-method}
\alias{show,FitDiff-method}
\alias{summary,FitDiff-method}
\title{Class For Representing A Template of Model Fit Comparisons}
\usage{
\S4method{show}{FitDiff}(object)

\S4method{summary}{FitDiff}(object, fit.measures = "default")
}
\arguments{
\item{object}{object of class \code{FitDiff}}

\item{fit.measures}{\code{character} vector naming fit indices the user can
request from \code{\link[lavaan]{fitMeasures}}. If \code{"default"}, the
fit measures will be \code{c("chisq", "df", "pvalue", "cfi", "tli",
"rmsea", "srmr", "aic", "bic")}. If \code{"all"}, all available fit measures
will be returned.}
}
\description{
This class contains model fit measures and model fit comparisons among
multiple models
}
\section{Slots}{

\describe{
\item{\code{name}}{The name of each model}

\item{\code{nested}}{Model fit comparisons between adjacent nested models that are
ordered based on their degrees of freedom (\emph{df})}

\item{\code{ordernested}}{The order of nested models regarding to their \emph{df}}

\item{\code{fit}}{Fit measures of all models specified in the \code{name} slot}
}}

\section{Objects from the Class}{
 Objects can be created via the
 \code{\link{compareFit}} function.
}

\examples{

HW.model <- ' visual =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
              speed =~ x7 + x8 + x9 '

out <- measurementInvariance(model = HW.model, data = HolzingerSwineford1939,
                             group = "school", quiet = TRUE)
modelDiff <- compareFit(out)
summary(modelDiff)
summary(modelDiff, fit.measures = "all")
summary(modelDiff, fit.measures = c("aic", "bic"))

\dontrun{
## Save results to a file
saveFile(modelDiff, file = "modelDiff.txt")

## Copy to a clipboard
clipboard(modelDiff)
}

}
\seealso{
\code{\link{compareFit}}; \code{\link{clipboard}}
}
\author{
Sunthud Pornprasertmanit (\email{psunthud@gmail.com})
}
