% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{genLambda}
\alias{genLambda}
\title{genLambda}
\usage{
genLambda(
  loadings = NULL,
  nIndicator = NULL,
  loadM = NULL,
  loadSD = NULL,
  loadMinMax = NULL
)
}
\arguments{
\item{loadings}{A list providing the loadings by factor, e. g. \code{list(c(.4, .5, .6), c(7, .8, .8))} to define two factors with three indicators each with the specified loadings. The vectors must not contain secondary loadings.}

\item{nIndicator}{Vector indicating the number of indicators for each factor, e. g. \code{c(4, 6)} to define two factors with 4 and 6 indicators, respectively}

\item{loadM}{Either a vector giving the mean loadings for each factor or a single number to use for every loading.}

\item{loadSD}{Either a vector giving the standard deviation of loadings for each factor or a single number, for use in conjunction with \code{loadM}. If \code{NULL}, SDs are set to zero. Otherwise, loadings are sampled from a normal distribution.}

\item{loadMinMax}{A list giving the minimum and maximum loading for each factor or a vector to apply to all factors. If set, loadings are sampled from a uniform distribution.}
}
\value{
The loading matrix Lambda.
}
\description{
Generate a loading matrix Lambda from various shortcuts, each assuming a simple structure.
Either define \code{loadings}, or define \code{nIndicator} and \code{loadM} (and optionally \code{loadSD}), or define
\code{nIndicator} and \code{loadMinMax}.
}
