% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capabilities.R
\name{chrome_options}
\alias{chrome_options}
\alias{firefox_options}
\alias{edge_options}
\title{Custom browser options}
\usage{
chrome_options(
  binary = NULL,
  args = NULL,
  extensions = NULL,
  prefs = NULL,
  ...
)

firefox_options(binary = NULL, args = NULL, profile = NULL, prefs = NULL, ...)

edge_options(binary = NULL, args = NULL, extensions = NULL, prefs = NULL, ...)
}
\arguments{
\item{binary}{Path to the browser binary.}

\item{args}{A character vector of additional arguments to pass to the
browser.}

\item{extensions}{A character vector of paths to browser extension (\code{.crx})
files. These will be base64 encoded before being passed to the browser. If
you have already  encoded the extensions, you can pass them using \code{\link[=I]{I()}}.
For Firefox, use a profile to load extensions.}

\item{prefs}{A named list of preferences to set in the browser.}

\item{...}{Additional options to pass to the browser.}

\item{profile}{Path to a Firefox profile directory. This will be base64
encoded before being passed to the browser.}
}
\value{
A list of browser options, with Chrome options under the name
\code{goog:chromeOptions}, Firefox options under \code{moz:firefoxOptions}, and Edge
options under \code{ms:edgeOptions}.
}
\description{
Create browser options to pass into the \code{capabilities} argument of
\link[=SeleniumSession]{SeleniumSession$new()}.
}
\details{
These functions allow you to more easily translate between Selenium code in
other languages (e.g. Java/Python) to R. For example, consider the following
Java code, adapted from the the
\href{https://www.selenium.dev/documentation/webdriver/browsers/chrome/}{Selenium documentation}

\if{html}{\out{<div class="sourceCode java">}}\preformatted{ChromeOptions options = new ChromeOptions();

options.setBinary("/path/to/chrome");
options.addArguments("--headless", "--disable-gpu");
options.addExtensions("/path/to/extension.crx");
options.setExperimentalOption("excludeSwitches", List.of("disable-popup-blocking"));
}\if{html}{\out{</div>}}

This can be translated to R as follows:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{chrome_options(
  binary = "/path/to/chrome",
  args = c("--headless", "--disable-gpu"),
  extensions = "/path/to/extension.crx",
  excludeSwitches = list("disable-popup-blocking")
)
}\if{html}{\out{</div>}}

You can combine these options with non-browser specific options simply using
\code{\link[=c]{c()}}.

Note that Microsoft Edge options are very similar to Chrome options, since
it is based on Chromium.
}
\examples{
# Basic options objects
chrome_options(
  binary = "/path/to/chrome",
  args = c("--headless", "--disable-gpu"),
  detatch = TRUE, # An additional option described in the link above.
  prefs = list(
    "profile.default_content_setting_values.notifications" = 2
  )
)


firefox_options(binary = "/path/to/firefox")

edge_options(binary = "/path/to/edge")

# Setting the user agent
chrome_options(args = c("--user-agent=My User Agent"))

edge_options(args = c("--user-agent=My User Agent"))

firefox_options(prefs = list(
  "general.useragent.override" = "My User Agent"
))

# Using a proxy server

chrome_options(args = c("--proxy-server=HOST:PORT"))

edge_options(args = c("--proxy-server=HOST:PORT"))

PORT <- 1
firefox_options(prefs = list(
  "network.proxy.type" = 1,
  "network.proxy.socks" = "HOST",
  "network.proxy.socks_port" = PORT,
  "network.proxy.socks_remote_dns" = FALSE
))

# Combining with other options
browser_options <- chrome_options(binary = "/path/to/chrome")

c(browser_options, list(platformName = "Windows"))

}
\seealso{
For more information and examples on Chrome options, see:
\url{https://developer.chrome.com/docs/chromedriver/capabilities}

For Firefox options:
\url{https://developer.mozilla.org/en-US/docs/Web/WebDriver/Capabilities/firefoxOptions}

For other options that affect Firefox but are not under \code{mox:firefoxOptions},
see:
\url{https://firefox-source-docs.mozilla.org/testing/geckodriver/Capabilities.html}

For Edge options, see:
\url{https://learn.microsoft.com/en-us/microsoft-edge/webdriver-chromium/capabilities-edge-options#edgeoptions-object}
}
