% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectivity.R
\name{ivlev}
\alias{ivlev}
\title{Ivlev's electivity (Ivlev 1961).
Returns Ivlev's electivity index from vectors of consumed and available food items.}
\usage{
ivlev(available, consumed, jacob = FALSE)
}
\arguments{
\item{available}{A vector of food items available to the organism in the environment}

\item{consumed}{A vector of food items consumed by the organism}

\item{jacob}{Converts to Jacob's electivity index? Defaults to FALSE.}
}
\description{
Ivlev's electivity (Ivlev 1961).
Returns Ivlev's electivity index from vectors of consumed and available food items.
}
\examples{
availableprey <- c(10,10,10,10,10)
consumedprey <- c(9,0,0,1,5)
ivlev(available = availableprey, consumed = consumedprey, jacob = FALSE)
ivlev(available = availableprey, consumed = consumedprey, jacob = TRUE)

}
\keyword{ivlev}
\keyword{selectivity}
