% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hieralg.R
\name{hieralg}
\alias{hieralg}
\title{Segment data into change points assuming hierarchical structure}
\usage{
hieralg(data, likelihood, max_segments = ncol(data),
  allow_parallel = TRUE)
}
\arguments{
\item{data}{matrix for which to find the change points}

\item{likelihood}{a function receives the segment matrix as argument
and returns a likelihood estimation. This function is used to calculate the
change points that maximize the total likelihood. Depending on the algorithm
being used, this function is likely to be executed many times, in which
case it's also likely to be the bottleneck of the function execution, so
it's advised that this function should have fast implementation.}

\item{max_segments}{an integer that defines the maximum amount of segments to
split the data into.}

\item{allow_parallel}{allows parallel execution to take place using the
registered cluster. Assumes a cluster is registered with the \code{foreach}
package. Defaults to TRUE.}
}
\value{
a list of type \code{segmentr}, which has the two attributes:
\itemize{
\item \code{changepoints}: a vector with the first index of each identified change point
\item \code{segments}: a list of vectors, in which each vector corresponds to the indices
that identifies a segment.
}
}
\description{
By assuming change points follow an hierarchical architecture, this architecture
manages to run faster by not searching all possible branches
}
\details{
Fast algorithm that segments data into change points, and it does so by
simplifying by reducing the search possibilities by assuming data split in an
hierarchical structure, i.e. a segment found in a first trial is assumed to
contain only segments independent of the rest of the data. This algorithm
usually runs very fast, but is known to yield less accurate results, possibly
not finding the exact change points that would maximize likelihood.
}
