% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bayesfactor_parameters.R
\name{plot.see_bayesfactor_parameters}
\alias{plot.see_bayesfactor_parameters}
\title{Plot method for Bayes Factors for a single parameter}
\usage{
\method{plot}{see_bayesfactor_parameters}(
  x,
  size_point = 2,
  rope_color = "#0171D3",
  rope_alpha = 0.2,
  show_intercept = FALSE,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{size_point}{Numeric specifying size of point-geoms.}

\item{rope_color}{Character specifying color of ROPE ribbon.}

\item{rope_alpha}{Numeric specifying transparency level of ROPE ribbon.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the
intercept-parameter has a posterior distribution on a very different
location, so density curves of posterior distributions for other parameters
are hardly visible.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{bayestestR::bayesfactor_parameters()} function.
}
