% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.check_distribution.R
\name{plot.see_check_distribution}
\alias{plot.see_check_distribution}
\title{Plot method for classifying the distribution of a model-family}
\usage{
\method{plot}{see_check_distribution}(x, point_size = 2, panel = TRUE, ...)
}
\arguments{
\item{x}{An object.}

\item{point_size}{Size of point-geoms.}

\item{panel}{Logical, if \code{TRUE}, plots are arranged as panels; else,
single plots are returned.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{performance::check_distribution()} function.
}
\examples{
library(performance)
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
result <- check_distribution(m)
result
plot(result)
}
