% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitMod.R
\name{fitMod}
\alias{fitMod}
\title{Internal function that fits the seawaveQ model.}
\usage{
fitMod(
  cdatsub,
  cavdat,
  yrstart,
  yrend,
  tndbeg,
  tndend,
  tanm,
  pnames,
  qwcols,
  mclass = 1,
  numk = 4,
  plotfile = FALSE,
  textfile = FALSE
)
}
\arguments{
\item{cdatsub}{is the concentration data.}

\item{cavdat}{is the continuous (daily) ancillary data.}

\item{yrstart}{is the starting year of the analysis (treated as January
1 of that year).}

\item{yrend}{is the ending year of the analysis (treated as December 31
of that year).}

\item{tndbeg}{is the beginning (in whole or decimal years) of the 
trend period.}

\item{tndend}{is the end (in whole or decimal years) of the trend 
period.}

\item{tanm}{is a character identifier that names the trend 
analysis run.  It is used to label output files.}

\item{pnames}{is the parameter (water-quality constituents) to 
analyze (if using USGS parameters, omit the starting 'P', such as 
"00945" for sulfate).}

\item{qwcols}{is a character vector with the beginning of the
column headers for remarks code (default is R), and beginning of 
column headers for concentration data (default is P for parameter).}

\item{mclass}{indicates the class of model to use.
A class 1 model is the the traditional SEAWAVE-Q model that has a
linear time trend. A class 2 model is a newer option for longer
trend periods that uses a set of restricted cubic splines on the 
time variable to provide a more flexible model. The default is 1.
(Harrell, 2010, 2018).}

\item{numk}{is the number of knots in the restricted cubic spline model
(mclass = 2). The default is 4, and the recommended number is 3--7.}

\item{plotfile}{is by default FALSE. True will write pdf files of plots to 
the user's file system.}

\item{textfile}{is by default FALSE. True will write text output files
to the user's file system. These files are useful for detailed model 
comparisons, documenting session information, and for model archives.}
}
\value{
A PDF file (if plotfile is TRUE) containing plots (see 
\code{\link{seawaveQPlots}}), a text file showing the best model survival 
regression call and results, and a list. The first element of the list 
contains information about the data and the model(s) selected (see 
\code{\link{examplestpars}}). The second element of the list contains 
the summary of the survival regression call. The third element of the 
list is itself a list containing the observed concentrations (censored 
and uncensored) and the predicted concentrations used by 
\code{\link{seawaveQPlots}} or \code{\link{seawaveQPlots2}} to generate the 
plots.
}
\description{
fitMod is called from within \link{fitswavecav} but
can be invoked directly. It fits the seawaveQ model and returns the 
results.
}
\examples{
data(swData)
myRes <- fitMod(cdatsub = examplecdatsub, cavdat = examplecavdat, 
yrstart = 1995, yrend = 2003, tndbeg = 1995, tndend = 2003, tanm = "myfit3", 
pnames = c("04041"), qwcols = c("R", "P"), plotfile = FALSE,
textfile = FALSE)
}
\references{
Allison, P.D., 1995, Survival analysis using the SAS system---A 
practical guide: Cary, N.C., SAS Institute, Inc., 304 p.

Harrell, F.E., Jr., 2010, Regression modeling strategies---With
applications to linear models, logistic regression, and survival
analysis: New York, Springer-Verlag, 568 p.

Harrell, F.E., Jr., 2018, rms---Regression modeling strategies: 
R package version 5.1-2, \url{https://CRAN.R-project.org/package=rms}.
}
\author{
Aldo V. Vecchia and Karen R. Ryberg
}
\keyword{models}
\keyword{multivariate}
\keyword{regression}
\keyword{survival}
\keyword{ts}
