% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marinetrophicindex.R
\name{marinetrophicindex}
\alias{marinetrophicindex}
\title{Get MTI as a data frame or chart}
\usage{
marinetrophicindex(region, id, chart = FALSE, type = "mean_trophic_level",
  transferefficiency = 0.1, ...)
}
\arguments{
\item{region}{(character) region type. one of: eez, lme, rfmo, highseas,
fao, eez-bordering, fishing-entity, taxon, or global}

\item{id}{(character/integer/numeric) region id. depends on what
\code{region} is specified. See \code{\link{regions}} for details}

\item{chart}{boolean to return a chart versus a data frame
Default: \code{FALSE}}

\item{type}{MTI data set ("mean_trophic_level", "fib_index", or "rmti")
Default: "mean_trophic_level"}

\item{transferefficiency}{float used for FiB index input
Default: 0.1}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
data frame (or chart) with MTI data
}
\description{
Get MTI as a data frame or chart
}
\examples{
marinetrophicindex(region = "eez", id = 76)
marinetrophicindex("eez", 76, type="fib_index")
marinetrophicindex("eez", 76, type="fib_index", transferefficiency=0.25)
\dontrun{
marinetrophicindex("eez", 76, chart=TRUE)
}
}
