% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlp.R
\name{sqlp}
\alias{sqlp}
\title{Semidefinite Quadratic Linear Programming Solver}
\usage{
sqlp(blk = NULL, At = NULL, C = NULL, b = NULL, OPTIONS = NULL,
  X0 = NULL, y0 = NULL, Z0 = NULL, sqlp_obj = NULL)
}
\arguments{
\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}

\item{At}{A matrix object containing constraint matrices for the primal-dual problem}

\item{C}{A matrix object containing the constant $c$ matrices in the primal objective function}

\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}

\item{OPTIONS}{A list object specifying the values of certain parameters. If not provided, default values are used}

\item{X0}{An initial iterate for the primal solution variable X. If not provided, an initial iterate is computed internally.}

\item{y0}{An initial iterate for the dual solution variable y. If not provided, an initial iterate is computed internally.}

\item{Z0}{An initial iterate for the dual solution variable Z. If not provided, an initial iterate is computed internally.}

\item{sqlp_obj}{A class object variable of type "sqlp_input" eminating from one of the built in functions (i.e., maxcut, nearcorr, etc.)}
}
\value{
\item{X}{The solution matrix to the primal problem}
\item{y}{The solution vector to the dual problem}
\item{Z}{The solution matrix to the dual problem}
\item{pobj}{The achieved value of the primary objective function}
\item{dobj}{The achieved value of the dual objective function}
}
\description{
\code{sqlp} solves a semidefinite quadratic linear programming problem using the SDPT3 algorithm of Toh et. al. (1999)
returning both the primal solution X and dual solution Z.
}
\details{
A full mathematical description of the problem to be solved, details surrounding the
input variables, and discussion regarding the output variables can be found in the accompanying vignette.
}
\examples{
#Solve the MaxCut problem using the built in adjacency matrix B
data(Bmaxcut)
out <- maxcut(Bmaxcut)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b

out <- sqlp(blk,At,C,b)

#Alternatiee Input Method (Not Run)
#out <- sqlp(sqlp_obj=out)

}
\references{
K.C. Toh, M.J. Todd, and R.H. Tutuncu, SDPT3 --- a Matlab software package for semidefinite programming, Optimization Methods and Software, 11 (1999), pp. 545--581.
R.H Tutuncu, K.C. Toh, and M.J. Todd, Solving semidefinite-quadratic-linear programs using SDPT3, Mathematical Programming Ser. B, 95 (2003), pp. 189--217.
}

