% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{Effect.sdmTMB}
\alias{Effect.sdmTMB}
\title{Calculate effects}
\usage{
Effect.sdmTMB(focal.predictors, mod, ...)
}
\arguments{
\item{focal.predictors}{a character vector of one or more predictors in the model in any order.}

\item{mod}{a regression model object.  If no specific method exists for the class of \code{mod}, \code{Effect.default} will be called.}

\item{...}{arguments to be passed down.}
}
\value{
Output from \code{\link[effects:effect]{effects::effect()}}. Can then be plotted with with associated
\code{plot()} method.
}
\description{
Used by effects package
}
\examples{
\dontshow{if (require("effects", quietly = TRUE)) withAutoprint(\{ # examplesIf}
fit <- sdmTMB(present ~ depth_scaled, data = pcod_2011, family = binomial(),
  spatial = "off")
effects::effect("depth_scaled", fit)
plot(effects::effect("depth_scaled", fit))
\dontshow{\}) # examplesIf}
}
