% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acquire_error.R
\name{acquire_error_flag}
\alias{acquire_error_flag}
\title{Add a column of error flags given  two data frames.}
\usage{
acquire_error_flag(df1, diffs.table, var_name, error_type)
}
\arguments{
\item{df1}{Data frame 1.}

\item{diffs.table}{A data frame of differnces between two data frames given by \code{\link{compare_two_df}}.}

\item{var_name}{A string of variable name that we want to check if there is error.}

\item{error_type}{A string of error type name:
\enumerate{
\item {missing}: if the value of \code{var_name} is NA in \code{df2}, it will be flagged
    as 1, otherwise, 0;
\item {del}: if the value of \code{var_name} in \code{df2} equals to \code{var_name} in \code{df1}
    with a letter being deleted (see \code{\link{get_transformation_del}}), it will be flagged as 1, otherwise, 0;
\item {trans_char}: if the value of \code{var_name} in \code{df2} equals to \code{var_name} in \code{df1}
    with two of its letters' position being transposed (see \code{\link{get_transformation_trans_char}}), it will be flagged as 1, otherwise, 0;
\item {trans_date}: if the value of \code{var_name} in \code{df2} equals to \code{var_name} in \code{df1}
    with day and month being transposed (see \code{\link{get_transformation_trans_date}}), it will be flagged as 1, otherwise, 0;
\item {insert}: if the value of \code{var_name} in \code{df2} equals to \code{var_name} in \code{df1}
    with an additional letter being inserted (see \code{\link{get_transformation_insert}}), it will be flagged as 1, otherwise, 0;
\item {typo}: if the value of \code{var_name} in \code{df2} equals to \code{var_name} in \code{df1}
    with a typo error (see \code{\link{get_transformation_typo}}), it will be flagged as 1, otherwise, 0;
\item {ocr}: if the value of \code{var_name} in \code{df2} equals to \code{var_name} in \code{df1}
    with an ocr error (see \code{\link{get_transformation_ocr}}), it will be flagged as 1, otherwise, 0;
\item {pho}: if the value of \code{var_name} in \code{df2} equals to \code{var_name} in \code{df1}
    with a phonetic error (see \code{\link{get_transformation_pho}}), it will be flagged as 1, otherwise, 0;
\item {variant}: if the value of \code{var_name} in \code{df2} equals to a variant of \code{var_name} in \code{df1}
    (see \code{\link{get_transformation_name_variant}}), it will be flagged as 1, otherwise, 0;
}}
}
\value{
It returns a data frame of \code{df1} with an additional error flag column called \code{var_name}.
}
\description{
\code{compare_two_df} compares the \code{vars} of data frames given an \code{uniqueId}.
}
\examples{
df <- data.frame(firstname_variant=character(20), lastname_variant=character(20))
df <- add_variable(df, "nhsid")
df <- add_variable(df, "firstname", country = "uk", gender_dependency= FALSE,
                   age_dependency = FALSE)
df <- add_variable(df, "lastname", country = "uk", gender_dependency= FALSE,
                   age_dependency = FALSE)
df$firstname_variant <-as.character(df$firstname_variant)
df$lastname_variant <-as.character(df$lastname_variant)
for (i in 1:nrow(df)){
  df$firstname_variant[i] = strsplit(get_transformation_name_variant(df$firstname[i]), ',')[[1]][1]
  df$lastname_variant[i] = strsplit(get_transformation_name_variant(df$lastname[i]), ',')[[1]][1]
}
df1 = df[c('nhsid', 'firstname', 'lastname')]
df2 = df[c('nhsid', 'firstname_variant', 'lastname_variant')]
df2[1:3, 'firstname_variant'] = NA
vars = list(c('firstname', 'firstname_variant'), c('lastname', 'lastname_variant'))
diffs.table = compare_two_df(df1, df2, vars, 'nhsid')
df1_with_flags = acquire_error_flag(df1, diffs.table, 'firstname', 'missing')
df1_with_flags = acquire_error_flag(df1_with_flags, diffs.table, 'firstname', 'variant')
df1_with_flags = acquire_error_flag(df1_with_flags, diffs.table, 'firstname', 'pho')
df1_with_flags = acquire_error_flag(df1_with_flags, diffs.table, 'firstname', 'ocr')

}
