% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changeCellStatus.R
\name{changeCellStatus}
\alias{changeCellStatus}
\title{change anonymization status of a specific cell}
\usage{
changeCellStatus(object, characteristics, varNames, rule, verbose = FALSE)
}
\arguments{
\item{object}{an object of class \code{\link{sdcProblem-class}}}

\item{characteristics}{a character vector specifying characteristics of the table cell that should be identified for each dimensional variable defining the table}

\item{varNames}{a character vector specifying variable names of dimensional variables defining the tables}

\item{rule}{character vector of length 1 specifying a valid anonymization code ('u', 'z', 'x', 's') to which the the cell under consideration should be set.}

\item{verbose}{logical vector of length 1 defining verbosity, defaults to 'FALSE'}
}
\value{
a \code{\link{sdcProblem-class}} object
}
\description{
Function \code{\link{changeCellStatus}} allows to change|modify the anonymization state
of single table cells for objects ofs class \code{\link{sdcProblem-class}}.
}
\note{
Important: the \code{i}-th element of argument \code{characteristics} is uses as the desired characteristic for the dimensional variable specified at the \code{i}-th position of argument \code{varNames}!
}
\examples{
# load primary suppressed data (as created in the example
# of \code{\link{primarySuppression}})
sp <- searchpaths()
fn <- paste(sp[grep("sdcTable", sp)], "/data/problemWithSupps.RData", sep="")
problem <- get(load(fn))

# we want to mark the cell region='D' and gender='male' primary sensitive
characteristics <- c('D', 'male')
varNames <- c('region', 'gender')
verbose <- TRUE
rule <- 'u'

# looking at the distribution of anonymization states before...
print(table(getInfo(problem, 'sdcStatus')))

# setting the specific cell as primary sensitive
problem <- changeCellStatus(problem, characteristics, varNames, rule, verbose)

# having a second look at the anonymization states
print(table(getInfo(problem, 'sdcStatus')))

}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
