% Generated by roxygen2 (4.0.1): do not edit by hand
\name{mdf_ga}
\alias{mdf_ga}
\title{Marginal Density for Given Scale Parameter and Half-Normal Prior for \eqn{\tau}}
\usage{
mdf_ga(f, theta, Z, Kinv)
}
\arguments{
\item{f}{point the marginal density to be evaluated at.}

\item{theta}{denotes the scale parameter of the gamma hyperprior for \eqn{\tau^2} (half-normal for \eqn{\tau}).}

\item{Z}{the row of the design matrix evaluated.}

\item{Kinv}{the generalised inverse of K.}
}
\value{
the marginal density evaluated at point x.
}
\description{
This function computes the marginal density of \eqn{z_p'\beta} for gamma priors for \eqn{\tau^2}
(referring to a half-normal prior for \eqn{\tau}).
}
\examples{
set.seed(123)
library(MASS)
# prior precision matrix (second order differences)
# of a spline of degree l=3 and with m=20 inner knots
# yielding dim(K)=m+l-1=22
K <- t(diff(diag(22), differences=2))\%*\%diff(diag(22), differences=2)
# generalised inverse of K
Kinv <- ginv(K)
# covariate x
x <- runif(1)
Z <- matrix(DesignM(x)$Z_B,nrow=1)
fgrid <- seq(-3,3,length=1000)
mdf <- mdf_ga(fgrid,theta=0.0028,Z=Z,Kinv=Kinv)
}
\author{
Nadja Klein
}
\references{
Nadja Klein and Thomas Kneib (2015). Scale-Dependent Priors for Variance Parameters in Structured Additive Distributional Regression.
\emph{Working Paper}.
}

