% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq-decimal.R
\name{seq-decimal}
\alias{seq-decimal}
\alias{seq_endpoint}
\alias{seq_distance}
\alias{seq_endpoint_df}
\alias{seq_distance_df}
\title{Sequence generation at decimal level}
\usage{
seq_endpoint(from, to, offset_from = 0L, offset_to = 0L, string_output = TRUE)

seq_distance(
  from,
  by = NULL,
  length_out = 10L,
  dir = 1,
  offset_from = 0L,
  string_output = TRUE
)

seq_endpoint_df(
  .from,
  .to,
  ...,
  .offset_from = 0L,
  .offset_to = 0L,
  .string_output = TRUE
)

seq_distance_df(
  .from,
  .by = NULL,
  ...,
  .length_out = 10L,
  .dir = 1,
  .offset_from = 0L,
  .string_output = TRUE
)
}
\arguments{
\item{from, .from}{Numeric (or string coercible to numeric). Starting point of
the sequence.}

\item{to, .to}{Numeric (or string coercible to numeric). Endpoint of the
sequence. Only in \code{seq_endpoint()} and \code{seq_endpoint_df()}.}

\item{offset_from, .offset_from}{Integer. If set to a non-zero number, the
starting point will be offset by that many units on the level of the last
decimal digit. Default is \code{0}.}

\item{offset_to, .offset_to}{Integer. If set to a non-zero number, the
endpoint will be offset by that many units on the level of the last decimal
digit. Default is \code{0}. Only in \code{seq_endpoint()} and \code{seq_endpoint_df()}.}

\item{string_output, .string_output}{Logical or string. If \code{TRUE} (the
default), the output is a string vector. Decimal places are then padded
with zeros to match \code{from}'s (or \code{to}'s) number of decimal places. \code{"auto"}
works like \code{TRUE} if and only if \code{from} (\code{.from}) is a string.}

\item{by, .by}{Numeric. Only in \code{seq_distance()} and \code{seq_distance_df()}. Step
size of the sequence. If not set, inferred automatically. Default is
\code{NULL}.}

\item{length_out, .length_out}{Integer. Length of the output vector (i.e., the
number of its values). Default is \code{10}. Only in \code{seq_distance()} and
\code{seq_distance_df()}.}

\item{dir, .dir}{Integer. If set to \code{-1}, the sequence goes backward. Default
is \code{1}. Only in \code{seq_distance()} and \code{seq_distance_df()}.}

\item{...}{Further columns, added as in \code{\link[tibble:tibble]{tibble::tibble()}}. Only in
\code{seq_endpoint_df()} and \code{seq_distance_df()}.}
}
\value{
String by default of \code{string_output}, numeric otherwise.
}
\description{
Functions that provide a smooth interface to generating
sequences based on the input values' decimal depth. Each function creates a
sequence with a step size of one unit on the level of the input values'
ultimate decimal digit (e.g., \code{2.45}, \code{2.46}, \code{2.47}, ...):
\itemize{
\item \code{seq_endpoint()} creates a sequence from one input value to another. For
step size, it goes by the value with more decimal places.
\item \code{seq_distance()} only takes the starting point and, instead of the
endpoint, the desired output length. For step size, it goes by the starting
point by default.
}

\code{seq_endpoint_df()} and \code{seq_distance_df()} are variants that create a data
frame. Further columns can be added as in \code{\link[tibble:tibble]{tibble::tibble()}}. Regular
arguments are the same as in the respective non-\code{df} function, but with a dot
before each.
}
\details{
If either \code{from} or \code{to} ends on zero, be sure to enter that value
as a string! This is crucial because trailing zeros get dropped from
numeric values. A handy way to format numeric values or number-strings
correctly is \code{\link[=restore_zeros]{restore_zeros()}}. The output of the present functions is
like that by default (of \code{string_output}).

In \code{seq_endpoint()} and \code{seq_endpoint_df()}, the step size is determined by
\code{from} and \code{to}, whichever has more decimal places. In \code{seq_distance()} and
\code{seq_distance_df()}, it's determined by the decimal places of \code{from}.

These functions are scrutiny's take on \code{\link[base:seq]{base::seq()}}, and themselves
wrappers around it.
}
\examples{
# Sequence between two points:
seq_endpoint(from = 4.7, to = 5)

# Sequence of some length; default is 10:
seq_distance(from = 0.93)
seq_distance(from = 0.93, length_out = 5)

# Both of these functions can offset the
# starting point...
seq_endpoint(from = 14.2, to = 15, offset_from = 4)
seq_distance(from = 14.2, offset_from = 4)

# ...but only `seq_endpoint()` can offset the
# endpoint, because of its `to` argument:
seq_endpoint(from = 9.5, to = 10, offset_to = 2)

# In return, `seq_distance()` can reverse its direction:
seq_distance(from = 20.03, dir = -1)

# Both functions have a `_df` variant that returns
# a data frame. Arguments are the same but with a
# dot, and further columns can be added as in
# `tibble::tibble()`:
seq_endpoint_df(.from = 4.7, .to = 5, n = 20)
seq_distance_df(.from = 0.43, .length_out = 5, sd = 0.08)
}
\seealso{
\code{\link[=seq_disperse]{seq_disperse()}} for sequences centered around the input.
}
