% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapper-function-helpers.R
\name{check_audit_special}
\alias{check_audit_special}
\title{Alert user if more specific \verb{audit_*()} summaries are available}
\usage{
check_audit_special(data, name_test)
}
\arguments{
\item{data}{The \code{audit()} method's input data frame.}

\item{name_test}{String (length 1). Short, plain-text name of the consistency
test, such as \code{"GRIM"}.}
}
\value{
No return value. Might print an alert.
}
\description{
(Note: Ignore this function if your \code{audit()} method calls
\code{audit_cols_minimal()}.)

Call \code{check_audit_special()} within an \code{audit()} method for a consistency
test mapper function, such as \code{audit.scr_grim_map()}. It checks if the
input data frame was the product of a function produced by
\code{function_map_seq()} or \code{function_map_total_n()}.

If so, the function issues a gentle alert to the user that points to
\code{audit_seq()} or \code{audit_total_n()}, respectively.
}
\seealso{
\code{vignette("consistency-tests-in-depth")}, for context.
}
