% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_names.R
\name{fix_names}
\alias{fix_names}
\title{Change taxonomic names to be the same for each taxon}
\usage{
fix_names(x, how = "shortest", replace = NULL)
}
\arguments{
\item{x}{(data.frame) A data.frame. the target taxonomic name
column should be 'name'}

\item{how}{One of a few different methods:
\itemize{
\item shortest - Takes the shortest name string that is likely to be the
prettiest to display name, and replaces alll names with that one, better
for maps, etc.
\item supplied - If this method, supply a vector of names to replace the
names with.
}}

\item{replace}{A data.frame of names to replace names in the occurrence
data.frames with. Only used if how="supplied". The data.frame should have
two columns: the first is the names to match in the input \code{x} data.frame,
and the second column is the name to replace with. The column names don't
matter.}
}
\value{
a data.frame
}
\description{
That is, this function attempts to take all the names that are synonyms,
for whatever reason (e.g., some names have authorities on them), and
collapses them to the same string - making data easier to deal with for
making maps, etc. OR - you can think of this as a tool for
}
\examples{
\dontrun{
df <- sample_data_7

# method: shortest
fix_names(df, how="shortest")$name

# method: supplied
(replace_df <- data.frame(
 one = unique(df$name), 
 two = c('P. contorta', 'P.c. var. contorta',
         'P.c. subsp bolanderi', 'P.c. var. murrayana'),
 stringsAsFactors = FALSE))
fix_names(df, how="supplied", replace = replace_df)$name
}
}
