% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-quantile.R
\name{ae_median_quantile}
\alias{ae_median_quantile}
\title{Absolute error of the median (quantile-based version)}
\usage{
ae_median_quantile(observed, predicted, quantile_level)
}
\arguments{
\item{observed}{Numeric vector of size n with the observed values.}

\item{predicted}{Numeric nxN matrix of predictive
quantiles, n (number of rows) being the number of forecasts (corresponding
to the number of observed values) and N
(number of columns) the number of quantiles per forecast.
If \code{observed} is just a single number, then predicted can just be a
vector of size N.}

\item{quantile_level}{Vector of of size N with the quantile levels
for which predictions were made.}
}
\value{
Numeric vector of length N with the absolute error of the median.
}
\description{
Compute the absolute error of the median calculated as
\deqn{
  |\text{observed} - \text{median prediction}|
}
The median prediction is the predicted value for which quantile_level == 0.5.
The function requires 0.5 to be among the quantile levels in \code{quantile_level}.
}
\section{Input format}{
\if{html}{
  \out{<div style="text-align: left">}
  \figure{metrics-quantile.png}{options: style="width:750px;max-width:100\%;"}
  \out{</div><p>}
  Overview of required input format for quantile-based forecasts
}
\if{latex}{
  \figure{metrics-quantile.png}
}
}

\examples{
observed <- rnorm(30, mean = 1:30)
predicted_values <- replicate(3, rnorm(30, mean = 1:30))
ae_median_quantile(
  observed, predicted_values, quantile_level = c(0.2, 0.5, 0.8)
)
}
\seealso{
\code{\link[=ae_median_sample]{ae_median_sample()}}
}
\keyword{metric}
