% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoringutils.R
\docType{package}
\name{scoringutils}
\alias{scoringutils}
\title{scoringutils}
\description{
This package is designed to help with assessing the quality of predictions.
It provides a collection of proper scoring rules and metrics as well that
can be accessed independently or collectively through a higher-level wrapper
function.

Predicitions can be either probabilistic forecasts (generally predictive
samples generated by Markov Chain Monte Carlo procedures), quantile
forecasts or point forecasts. The true values can be either continuous,
integer, or binary.

A collection of different metrics and scoring rules can be accessed through
the function \code{\link{eval_forecasts}}. Given a data.frame of the
correct form the function will automatically figure out the type of
prediction and true values and return appropriate scoring metrics.

Alternatively, the following functions can be accessed directly:

\itemize{
\item \code{\link{brier_score}}
\item \code{\link{pit}}
\item \code{\link{bias}}
\item \code{\link{sharpness}}
\item \code{\link{crps}}
\item \code{\link{logs}}
\item \code{\link{dss}}
}
}
