#' Retrieve information about an experiment
#'
#' This function is used to obtain experimental information -- such as *time and date* of the experiment,
#' *acquisition device*, and *version of the software* --
#' embedded in a result file (`.db`) generated by the ethoscope platform.
#'
#' @param FILE the name of the input file
#' @return a list containing fields for metadata entries
#' @seealso
#' * [load_ethoscope] -- to load the actual data
#' * [list_result_files] -- to list available files
#' @export
experiment_info <- function(FILE){
  con <- RSQLite::dbConnect(RSQLite::SQLite(), FILE, flags=RSQLite::SQLITE_RO)
  tryCatch(
    {metadata <- RSQLite::dbGetQuery(con, "SELECT * FROM METADATA")},
    finally={RSQLite::dbDisconnect(con)})

  v <- as.list(metadata$value)
  names(v) <- metadata$field
  #fixme explicitly GMT
  v$date_time <- as.POSIXct(as.integer(v$date_time),origin="1970-01-01",tz = "GMT")
  return(v)
}
