% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winsorZ.R
\name{winsorZ}
\alias{winsorZ}
\title{Winsorize outliers based on z-score cutoff to next
most extreme non-outlier value}
\usage{
winsorZ(x, zbound = 3)
}
\arguments{
\item{x}{The input variable to Winsorize.}

\item{zbound}{The Z-score cutoff (default=3, i.e. outliers are Z>3 | Z<-3).}
}
\value{
Output Winsorized variable
}
\description{
The \code{winsorZ} function identifies outliers based on Z-score cutoff
and replaces with the next most extreme non-outlier value.
This involves z-scoring the variable and identifying/replacing
any cases beyond the z-score threshold.
The \code{winsorZ_find} function is an optional companion
to flag any Z-score outliers to tally as needed.
}
\examples{
winsorZ(psydat$iq)
\dontrun{
psydat \%>\%
  dplyr::select(c(iq, anxT)) \%>\%
  map(winsorZ)
psydat \%>\% mutate_at(c("iq", "anxT"), list(~ winsorZ(.)))
psydat \%>\% mutate_if(is.double, list(~ winsorZ(.)))
}

}
