% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_prop_test.R
\name{scf_prop_test}
\alias{scf_prop_test}
\title{Test a Proportion in SCF Data}
\usage{
scf_prop_test(
  design,
  var,
  group = NULL,
  p = 0.5,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)
}
\arguments{
\item{design}{A \code{scf_mi_survey} object created by \code{\link[=scf_load]{scf_load()}}. Must contain replicate-weighted implicates.}

\item{var}{A one-sided formula indicating a binary variable (e.g., \code{~rich}).}

\item{group}{Optional one-sided formula indicating a binary grouping variable (e.g., \code{~female}). If omitted, a one-sample test is performed.}

\item{p}{Null hypothesis value. Defaults to \code{0.5} for one-sample, \code{0} for two-sample tests.}

\item{alternative}{Character. One of \code{"two.sided"} (default), \code{"less"}, or \code{"greater"}.}

\item{conf.level}{Confidence level for the confidence interval. Default is \code{0.95}.}
}
\value{
An object of class \code{"scf_prop_test"} with:
\describe{
\item{results}{A data frame with the pooled estimate, standard error, z-statistic, p-value, confidence interval, and significance stars.}
\item{proportions}{(Only in two-sample tests) A data frame of pooled proportions by group.}
\item{fit}{A list describing the method, null value, alternative hypothesis, and confidence level.}
}
}
\description{
Tests a binary variable's proportion against a null hypothesis (one-sample),
or compares proportions across two groups (two-sample). Supports two-sided,
less-than, or greater-than alternatives.
}
\section{Statistical Notes}{

Proportions are computed in each implicate using weighted means, and variances are approximated under the binomial model.
Rubin’s Rules are applied to pool point estimates and standard errors. For pooling details, see \code{\link[=scf_MIcombine]{scf_MIcombine()}}.
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td  <- tempdir()
src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Wrangle data for example
scf2022 <- scf_update(scf2022,
  rich   = networth > 1e6,
  female = factor(hhsex, levels = 1:2, labels = c("Male","Female")),
  over50 = age > 50
)

# Example for real analysis: One-sample test
scf_prop_test(scf2022, ~rich, p = 0.10)

# Example for real analysis: Two-sample test
scf_prop_test(scf2022, ~rich, ~female, alternative = "less")

# Do not implement these lines in real analysis: Cleanup for package check
unlink("scf2022.rds", force = TRUE)


}
\seealso{
\code{\link[=scf_ttest]{scf_ttest()}}, \code{\link[=scf_mean]{scf_mean()}}, \code{\link[=scf_MIcombine]{scf_MIcombine()}}
}
