#' @rdname export
#' @export
export.sc_overlap <- function(object, caption = NA, footnote = NA, 
                              filename = NA,
                              kable_styling_options = list(), 
                              kable_options = list(), 
                              round = 2,
                              flip = FALSE,
                              ...) {
  
  kable_options <- .join_kabel(kable_options)
  kable_styling_options <- .join_kabel_styling(kable_styling_options)
  
  if (is.na(caption)) caption <- c(
    "Overlap indices. ",
    .phases_string(
      object$phases.A, 
      object$phases.B
    )
  )
  
  footnote <- c(
    "PND = Percentage Non-Overlapping Data; ",
    "PEM = Percentage Exceeding the Median; ",
    "PET = Percentage Exceeding the Trend; ",
    "NAP = Nonoverlap of all pairs; ",
    "NAP-R = NAP rescaled; ",
    "PAND = Percentage all nonoverlapping data;",
    "Tau U (A + B - trend A) = Parker's Tau-U; ",
    "Tau U (A + B - trend A + trend B) = Parker's Tau-U; ",
    "Base Tau = Baseline corrected Tau; ",
    "Delta M = Mean difference between phases; ",
    "Delta Trend = Trend difference between phases; ",
    "SMD = Standardized Mean Difference; ",
    "Hedges g = Corrected SMD",
    "."
  )
  footnote <- paste0(footnote, collapse = "")
  caption <- paste0(caption, collapse = "")
  
  kable_options$caption <- caption
  
  out <- object$overlap
  
  cn <- colnames(out)
  colnames(out)[which(cn == "NAP rescaled")] <- "NAP-R"
  colnames(out)[which(cn == "Tau_U(A)")] <- "Tau-U (A + B - trend A)"
  colnames(out)[which(cn == "Tau_U(BA)")] <- "Tau-U (A + B - trend A + trend B)"
  colnames(out)[which(cn == "Base_Tau")] <- "Base Tau"
  colnames(out)[which(cn == "Diff_mean")] <- "Delta M"
  colnames(out)[which(cn == "Diff_trend")] <- "Delta Trend"
  colnames(out)[which(cn == "Hedges_g")] <- "Hedges g"
  
  if (isTRUE(flip)) {
    cases <- out$Case
    out[-2:-1] <- round(out[-2:-1], round)
    out <- t(out[-1])
    colnames(out) <- cases
  }
  
  kable_options$x <- out
  table <- do.call(kable, kable_options)
  kable_styling_options$kable_input <- table
  table <- do.call(kable_styling, kable_styling_options)
  if (!is.na(footnote) && footnote != "") 
    table <- footnote(table, general = footnote, threeparttable = TRUE)
 
  # finish ------------------------------------------------------------------
  
  if (!is.na(filename)) cat(table, file = filename)
  table
}
