\name{smooth.construct.tesmd2.smooth.spec}
%\Rdversion{1.1}
\alias{smooth.construct.tesmd2.smooth.spec}
\title{Tensor product smoothing constructor for a bivariate function monotone decreasing
        in the second covariate
}
\description{This is a special method function
  for creating tensor product bivariate smooths monotone decreasing in the second covariate which is built by 
  the \code{mgcv} constructor function for smooth terms, \code{smooth.construct}. 
  It is constructed from a pair of single penalty
  marginal smooths. This tensor product is specified by model terms such as \code{s(x1,x2,k=c(q1,q2),bs="tesmd2",m=c(2,2))}, 
  where the basis for the first marginal smooth is specified in the second element of \code{bs}.
}
\usage{
\method{smooth.construct}{tesmd2.smooth.spec}(object, data, knots)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{A smooth specification object, generated by an \code{s} term in a GAM formula.} 

  \item{data}{A data frame or list containing the values of the elements of \code{object$term},
     with names given by \code{object$term}.}
 
  \item{knots}{An optional list containing the knots corresponding to \code{object$term}. 
          If it is \code{NULL} then the knot locations are generated automatically.}
 
}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
\value{An object of class \code{"tesmd2.smooth"}. In addition to the usual 
elements of a smooth class documented under \code{smooth.construct} of the \code{mgcv} library, 
this object contains:
\item{p.ident}{A vector of 0's and 1's for model parameter identification: 
     1's indicate parameters which will be exponentiated, 0's - otherwise.}
\item{Zc}{A matrix of identifiability constraints.}
\item{margin.class}{The class of the first unconstrained marginal smooth.}


}
\references{
Pya, N. and Wood, S.N. (2015) Shape constrained additive models. Statistics and Computing, 25(3), 543-559

Pya, N. (2010) Additive models with shape constraints. PhD thesis. University of Bath. Department of Mathematical Sciences

}
\author{
Natalya Pya <nat.pya@gmail.com>

}

\seealso{
 \code{\link{smooth.construct.tesmd1.smooth.spec}}}
\examples{
 \dontrun{
## tensor product `tesmd2' example 
  ## simulating data...
   set.seed(2)
   n <- 30
   x1 <- sort(runif(n)*4-1)
   x2 <- sort(runif(n))
   f1 <- matrix(0,n,n)
   for (i in 1:n) for (j in 1:n) 
       { f1[i,j] <- exp(4*x1[i])/(1+exp(4*x1[i])) - 2*exp(x2[j]-0.5)}
   f <- as.vector(t(f1))
   y <- f+rnorm(length(f))*0.1
   x11 <-  matrix(0,n,n)
   x11[,1:n] <- x1
   x11 <- as.vector(t(x11))
   x22 <- rep(x2,n)
   dat <- list(x1=x11,x2=x22,y=y)
## fit model ...
   b <- scam(y~s(x1,x2,k=c(10,10),bs="tesmd2",m=2),
            family=gaussian(link="identity"), data=dat,sp=NULL)
## plot results ...
   par(mfrow=c(2,2),mar=c(4,4,2,2))
   plot(b,se=TRUE)
   plot(b,pers=TRUE,theta = 90, phi = 60)
   plot(y,b$fitted.values,xlab="Simulated data",ylab="Fitted data")
 }
}
\keyword{models} \keyword{regression}%-- one or more ..
