% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATAC-seq.R
\name{ploidy}
\alias{ploidy}
\title{Infer Ploidy from ATAC-seq Fragment Overlap}
\usage{
ploidy(fragmentoverlap, levels, s = 100)
}
\arguments{
\item{fragmentoverlap}{Frequency of fragment overlap in each cell
computed by the function \code{fragmentoverlapcount}.}

\item{levels}{Possible values of ploidy. For example,
\code{c(2, 4)} if the cells can be diploids or tetraploids.
The values must be larger than one.}

\item{s}{Seed for random numbers used in EM algorithm.}
}
\value{
A data.frame with each row corresponding to a cell.
For each cell, its barcode, ploidy inferred by moment method,
the same with additional K-means clustering,
and ploidy inferred by EM algorithm of mixture are given.
I recommend using \code{ploidy.moment}.
}
\description{
Infer Ploidy from ATAC-seq Fragment Overlap
}
