% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_likelihood.R
\name{nlogL}
\alias{nlogL}
\alias{nlogL_pois}
\alias{nlogL_nb}
\alias{nlogL_pb}
\alias{nlogL_pois2}
\alias{nlogL_nb2}
\alias{nlogL_pb2}
\alias{nlogL_zipois}
\alias{nlogL_zinb}
\alias{nlogL_zipb}
\alias{nlogL_zipois2}
\alias{nlogL_zinb2}
\alias{nlogL_zipb2}
\title{Negative log Likelihood functions for Poisson, negative binomial and
Poisson-beta distributions}
\usage{
nlogL_pois(data, par.pois)

nlogL_nb(data, par.nb)

nlogL_pb(data, par.pb)

nlogL_pois2(data, par.pois2)

nlogL_nb2(data, par.nb2)

nlogL_pb2(data, par.pb2)

nlogL_zipois(data, par.zipois)

nlogL_zinb(data, par.zinb)

nlogL_zipb(data, par.zipb)

nlogL_zipois2(data, par.zipois2)

nlogL_zinb2(data, par.zinb2)

nlogL_zipb2(data, par.zipb2)
}
\arguments{
\item{data}{Vector containing the discrete observations}

\item{par.pois}{Scalar containing the lambda parameter
of the Poisson distribution}

\item{par.nb}{Vector of length 2, containing the size and the mu
parameter of the negative binomial distribution}

\item{par.pb}{Vector of length 3, containing the alpha, beta
and c parameter of the Poisson-beta distribution}

\item{par.pois2, par.nb2, par.pb2}{Vector containing the parameters
of the two mixing distributions. First entry represents the
fraction of the first distribution, followed by all parameters
of the first, then all of the second distribution.}

\item{par.zipois, par.zinb, par.zipb}{Vector containing the respective
zero-inflated distribution parameters. The additional first
entry is the inflation parameter for all cases.}

\item{par.zipois2, par.zinb2, par.zipb2}{Parameters for the zero-inflated
two population model.}
}
\description{
The negative log Likelihood functions for Poisson, negative binomial
and Poisson-beta distributions. Mixing two distributions of the same
kind and/or adding zero-inflation allows to take characteristics
of real data into account.
Additionally, one population and two population mixtures - with and
without zero-inflations - allow distribution fittings of the Poisson,
 negative binomial and the Poisson-beta distribution.
}
\details{
Functions nlogL_pois, nlogL_nb, nlogL_pb compute the negative
log-likelihood of Poisson, negative binomial and the Poisson-beta
distributions given the data.
Functions nlogL_pois2, nlogL_nb2 and nlogL_pb2 compute the negative
log-likelihood values for a two population mixture of distributions whereas
nlogL_zipois, nlogL_zinb, nlogL_zipb compute the same for the
zero-inflated distributions. Furthermore, nlogL_zipois2, nlogL_zinb2
and nlogL_zipb2 are for two population mixtures with zero-inflation.
}
\examples{
x <- rpois(100, 11)
nl1 <- nlogL_pois(x, 11)
nl2 <- nlogL_pois(x, 13)
x <- rnbinom(100, size = 13, mu = 9)
nl <- nlogL_nb(x, c(13, 9))
x <- rpb(n = 1000, alpha=5, beta= 3, c=20)
nl <- nlogL_pb(x, c(5, 3, 20))
s <- sample(x = c(0,1), size = 100, replace = TRUE, prob = c(0.3,0.7))
x <- s*rpois(100, 7) + (1-s)*rpois(100, 13)
nl1 <- nlogL_pois2(x, c(0.7, 13, 7))
nl2 <- nlogL_pois2(x, c(0.3, 7, 13))
## both values should be same: 296.9517
s <- sample(x = c(0,1), size = 100, replace = TRUE, prob = c(0.3,0.7))
x <-s*rnbinom(100, size = 13, mu = 9) + (1-s)*rnbinom(100, size = 17, mu = 29)
nl <- nlogL_nb2(x, c(0.7, 17, 29, 13, 9))
s <- sample(x = c(0,1), size = 100, replace = TRUE, prob = c(0.3,0.7))
x <- s*rpb(100, 5, 3, 20) + (1-s)*rpb(100, 7, 13, 53)
nl <- nlogL_pb2(x, c(0.7, 7, 13, 53, 5, 3, 20))
x <- c(rep(0, 10), rpois(90, 7))
nl <- nlogL_zipois(x, c(0.1, 7))
x <- c(rep(0,10), rnbinom(90, size = 13, mu = 9))
nl <- nlogL_zinb(x, c(0.1, 13, 9))
x <- c(rep(0, 10), rpb(n = 90, alpha=5, beta= 3, c=20))
nl <- nlogL_zipb(x, c(0.1, 5, 3, 20))
s <- sample(x = c(0,1), size = 90, replace = TRUE, prob = c(0.3,0.7))
x <- c(rep(0, 10), s*rpois(90, 7) + (1-s)*rpois(90, 13))
nl1 <- nlogL_zipois2(x, c(0.1, 0.63, 13, 7))
s <- sample(x = c(0,1), size = 90, replace = TRUE, prob = c(0.3,0.7))
x <- c(rep(0, 10), s*rnbinom(90, size = 13, mu = 9) + (1-s)*rnbinom(90, size = 17, mu = 29))
nl <- nlogL_zinb2(x, c(0.1, 0.63, 17, 29, 13, 9))
s <- sample(x = c(0,1), size = 90, replace = TRUE, prob = c(0.3,0.7))
x <- c(rep(0,10), s*rpb(90, 5, 3, 20) + (1-s)*rpb(90, 7, 13, 53))
nl <- nlogL_zipb2(x, c(0.1, 0.63, 7, 13, 53, 5, 3, 20))
}
\keyword{Poisson-beta}
\keyword{binomial}
\keyword{likelihood}
\keyword{negative}
