% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_from_count.R
\name{process_from_count}
\alias{process_from_count}
\title{Count Matrix To Seurat Object}
\usage{
process_from_count(
  countmat_list,
  name,
  theSpecies = -9,
  haveUmap = FALSE,
  saveALL = FALSE,
  panglao_set = FALSE,
  toSave = FALSE,
  path = NULL,
  use_sctransform = FALSE,
  genes_integrate = 2000,
  genes_include = FALSE
)
}
\arguments{
\item{countmat_list}{A list of count matrices that will be integrated using the IntegrationAnchors features they should have the same rownames. A dgCMatrix or matrix object is also acceptable, and no samples will be integrated.}

\item{name}{The output of the normalized and fused Seurat object if you choose to keep it.}

\item{theSpecies}{Gene symbols for human, mouse, or -9 if internal. If your species is not human or mouse gene symbols, make sure that you have "MT-" before your mitochondrial gene names then pick "human".}

\item{haveUmap}{Write a UMAP (T/F).}

\item{saveALL}{Save the Seurat object generated (T/F).}

\item{panglao_set}{If the function is being used from internal (T/F).}

\item{toSave}{Allows scMappR to print files and make directories locally (T/F).}

\item{path}{If toSave == TRUE, path to the directory where files will be saved.}

\item{use_sctransform}{If you should use sctransform or the Normalize/VariableFeatures/ScaleData pipeline (T/F).}

\item{genes_integrate}{The number of genes to include in the integration anchors feature when combining datasets}

\item{genes_include}{TRUE or FALSE -- include 2000 genes in signature matrix or all matrix.}
}
\value{
\code{process_from_count} A processed and integrated Seurat object that has been scaled and clustered. It can be returned as an internal object or also stored as an RData object if necessary. \cr
}
\description{
This function processes a list of count matrices (same species/gene symbols in each list) and converts them to a Seurat object.
}
\details{
This function takes a list of count matrices and returns a Seurat object of the count matrices integrated using Seurat v4 (and IntegrationAnchors feature). Different normalization features such as the SCTransform pipeline are also available in this function.
Different options are used when the function is being ran internally (i.e. reprocessing count matrices from PanglaoDB) or if it is running from custom scRNA-seq data.
Larger scRNA-seq datasets can take considerable amounts of memory and run-time. See Seurat for details.
}
\examples{
\donttest{

data(sm)
toProcess <- list(example = sm)
tst1 <- process_from_count(toProcess, "testProcess", theSpecies = "mouse")
}

}
