% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_generation.R
\name{heatmap_generation}
\alias{heatmap_generation}
\title{Generate Heatmap}
\usage{
heatmap_generation(
  genesIn,
  comp,
  reference,
  cex = 0.8,
  rd_path = "",
  cellTypes = "ALL",
  pVal = 0.01,
  isPval = TRUE,
  isMax = FALSE,
  isBackground = FALSE,
  which_species = "human",
  toSave = FALSE,
  path = NULL
)
}
\arguments{
\item{genesIn}{A list of gene symbols (all caps) to have their cell type enrichment.}

\item{comp}{The name of the comparison.}

\item{reference}{Path to signature matrix or the signature matrix itself.}

\item{cex}{The size of the genes in the column label for the heatmap.}

\item{rd_path}{The directory to RData files -- if they are not in this directory, then the files will be downloaded.}

\item{cellTypes}{Colnames of the cell-types you will extract (passed to extract_genes_cell).}

\item{pVal}{The level of association a gene has within a cell type (passed to extract_genes_cell).}

\item{isPval}{If the signature matrix is raw p-value (T/F) -- TRUE not recommended}

\item{isMax}{If you are taking the single best CT marker (T/F) -- TRUE not recommended}

\item{isBackground}{If the heatmap is from the entire signature matrix or just the inputted gene list (T/F). isBackground == TRUE is used for internal.}

\item{which_species}{Species of gene symbols -- "human" or "mouse" .}

\item{toSave}{Allow scMappR to write files in the path directory (T/F).}

\item{path}{If toSave == TRUE, path to the directory where files will be saved.}
}
\value{
List with the following elements:
\item{genesIn}{Vector of genes intersecting gene list and signature matrix.}
\item{genesNoIn}{Vector of inputted genes not in signature matrix.}
\item{geneHeat}{Signature matrix subsetted by inputted gene list}
\item{preferences}{Cell-markers mapping to cell-types.}
}
\description{
This function takes an inputted signature matrix as well as a list of genes and overlaps them.
 Then, if there is overlap, it prints a heatmap or barplot (depending on the number of overlapping genes).
 Then, for every cell-type, genes considered over-represented are saved in a list.
}
\examples{

\donttest{
# load in signature matrices
data(POA_example)
POA_generes <- POA_example$POA_generes
POA_OR_signature <- POA_example$POA_OR_signature
POA_Rank_signature <- POA_example$POA_Rank_signature
Signature <- POA_Rank_signature
rowname <- get_gene_symbol(Signature)
rownames(Signature) <- rowname$rowname
genes <- rownames(Signature)[1:100]
heatmap_test <- heatmap_generation(genesIn = genes, "scMappR_test",
                                   reference = Signature, which_species = "mouse")

 }

}
