% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prop_associations.R
\name{get_subtype_prop_associations}
\alias{get_subtype_prop_associations}
\title{Compute and plot associations between factor scores and cell subtype composition
for various clustering resolution parameters}
\usage{
get_subtype_prop_associations(
  container,
  max_res,
  stat_type,
  integration_var = NULL,
  min_cells_group = 50,
  use_existing_subc = FALSE,
  alt_ct_names = NULL,
  n_col = 2
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{max_res}{numeric The maximum clustering resolution to use. Minimum is 0.5.}

\item{stat_type}{character Either "fstat" to get F-Statistics, "adj_rsq" to get adjusted
R-squared values, or "adj_pval" to get adjusted pvalues.}

\item{integration_var}{character The meta data variable to use for creating
the joint embedding with Conos if not already provided in container$embedding (default=NULL)}

\item{min_cells_group}{numeric The minimum allowable size for cell subpopulations
(default=50)}

\item{use_existing_subc}{logical Set to TRUE to use existing subcluster annotations
(default=FALSE)}

\item{alt_ct_names}{character Cell type names used in clustering if different from those
used in the main analysis. Should match the order of container$experiment_params$ctypes_use.
(default=NULL)}

\item{n_col}{numeric The number of columns to organize the plots into (default=2)}
}
\value{
The project container with a cowplot figure of cell subtype proportion-factor
association results plots in container$plots$subtype_prop_factor_associations.
}
\description{
Compute and plot associations between factor scores and cell subtype composition
for various clustering resolution parameters
}
