% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_jackstraw.R
\name{get_min_sig_genes}
\alias{get_min_sig_genes}
\title{Evaluate the minimum number for significant genes in any factor for a given number of
factors extracted by the decomposition}
\usage{
get_min_sig_genes(
  container,
  donor_rank_range,
  gene_ranks,
  use_lm = TRUE,
  tucker_type = "regular",
  rotation_type = "hybrid",
  n_fibers = 100,
  n_iter = 500,
  n.cores = container$experiment_params$ncores,
  thresh = 0.05
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses. Should have}

\item{donor_rank_range}{numeric Range of possible number of donor factors to use.}

\item{gene_ranks}{numeric The number of gene ranks to use in the decomposition}

\item{use_lm}{logical Set to true to use get_lm_pvals otherwise uses jackstraw (default=TRUE)}

\item{tucker_type}{character Set to 'regular' to run regular tucker or to 'sparse' to run tucker
with sparsity constraints (default='regular')}

\item{rotation_type}{character Set to 'hybrid' to perform hybrid rotation on resulting donor factor
matrix and loadings. Otherwise set to 'ica_lds' to perform ica rotation on loadings or
ica_dsc to perform ica on donor scores. (default='hybrid')}

\item{n_fibers}{numeric The number of fibers the randomly shuffle in each jackstraw iteration
(default=100)}

\item{n_iter}{numeric The number of jackstraw shuffling iterations to complete (default=500)}

\item{n.cores}{Number of cores to use in get_lm_pvals() (default = container$experiment_params$ncores)}

\item{thresh}{numeric Pvalue threshold for significant genes in calculating the
number of significant genes identified per factor. (default=0.05)}
}
\value{
The project container with a plot of the minimum significant genes for
each decomposition with varying number of donor factors located in
container$plots$min_sig_genes.
}
\description{
Evaluate the minimum number for significant genes in any factor for a given number of
factors extracted by the decomposition
}
\examples{
test_container <- get_min_sig_genes(test_container, donor_rank_range=c(2:4),
gene_ranks=4, tucker_type='regular', rotation_type='hybrid', n.cores=1)
}
