% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_scGateDB}
\alias{get_scGateDB}
\title{Load scGate model database}
\usage{
get_scGateDB(
  destination = tempdir(),
  force_update = FALSE,
  version = "latest",
  branch = c("master", "dev"),
  verbose = FALSE,
  repo_url = "https://github.com/carmonalab/scGate_models"
)
}
\arguments{
\item{destination}{Destination path for storing the DB. The default is tempdir(); if you wish to edit locally the models and
link them to the current project, set this parameter to a new directory name, e.g. scGateDB}

\item{force_update}{Whether to update an existing database.}

\item{version}{Specify the version of the scGate_models database (e.g. 'v0.1'). By default downloads the latest available version.}

\item{branch}{branch of the scGate model repository, either 'master' (default) or 'dev' for the latest models}

\item{verbose}{display progress messages}

\item{repo_url}{URL path to scGate model repository database}
}
\value{
A list of models, organized according to the folder structure of the database. See the examples below.
}
\description{
Download, update or load local version of the scGate model database. These are stored in a GitHub repository, from where you can download specific 
versions of the database.
}
\details{
Models for scGate are dataframes where each line is a signature for a given filtering level. A database of models can be downloaded using the function
    \code{get_scGateDB}. You may directly use the models from the database, or edit one of these models to generate your own custom gating model.
}
\examples{
scGate.model.db <- get_scGateDB()
# To see a specific model, browse the list of models:
scGate.model.db$human$generic$Myeloid
}
\seealso{
\code{\link{scGate}} \code{\link{load_scGate_model}}
}
