% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{getCellTypeSharedTerms}
\alias{getCellTypeSharedTerms}
\title{query co-up and co-down regulated GO terms from certain cell type pairs}
\usage{
getCellTypeSharedTerms(
  shared_go,
  cell_type_sp1,
  cell_type_sp2,
  return_full = FALSE,
  arrange_avg_log2FC = TRUE
)
}
\arguments{
\item{shared_go}{cell type shared GO table from getCellTypeSharedGO}

\item{cell_type_sp1}{cell type from sp1 to query}

\item{cell_type_sp2}{cell type from sp2 to query}

\item{return_full}{if return also pvals and logfc info, default FALSE}

\item{arrange_avg_log2FC}{arrange result by decreasing mean avg_log2FC, default TRUE}
}
\value{
a dataframe displaying co-up or co-down regulated GO terms for the queried cell type pair
}
\description{
query co-up and co-down regulated GO terms from certain cell type pairs
}
\examples{
\donttest{
library(scGOclust)
library(httr)
httr::set_config(httr::config(ssl_verifypeer = FALSE))
data(mmu_tbl)
data(mmu_subset)
data(dme_tbl)
data(dme_subset)

mmu_go_obj = makeGOSeurat(ensembl_to_GO = mmu_tbl,
 seurat_obj = mmu_subset,
 feature_type = "external_gene_name")
dme_go_obj = makeGOSeurat(ensembl_to_GO = dme_tbl,
 seurat_obj = dme_subset,
 feature_type = "external_gene_name")


mmu_go_obj_analyzed = analyzeGOSeurat(mmu_go_obj, "cell_type_annotation")
dme_go_obj_analyzed = analyzeGOSeurat(dme_go_obj, "annotation")

shared_go = getCellTypeSharedGO(species_1 = 'mmusculus',
species_2 = 'dmelanogaster',
analyzed_go_seurat_sp1 = mmu_go_obj_analyzed,
analyzed_go_seurat_sp2 = dme_go_obj_analyzed,
cell_type_col_sp1 = 'cell_type_annotation',
cell_type_col_sp2 = 'annotation',
layer_use = "data",
p_val_threshould = 0.01)


getCellTypeSharedTerms(shared_go = shared_go,
cell_type_sp1 = 'intestine_Enteroendocrine cell',
cell_type_sp2 = 'enteroendocrine cell',
return_full = FALSE)
}
}
