% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Ultilities_Themes.R
\name{theme_ggprism_mod}
\alias{theme_ggprism_mod}
\title{Modified ggprism theme}
\usage{
theme_ggprism_mod(
  palette = "black_and_white",
  base_size = 14,
  base_family = "sans",
  base_fontface = "bold",
  base_line_size = base_size/20,
  base_rect_size = base_size/20,
  axis_text_angle = 0,
  border = FALSE
)
}
\arguments{
\item{palette}{\code{string}. Palette name, use
\code{names(ggprism_data$themes)} to show all valid palette names.}

\item{base_size}{\code{numeric}. Base font size, given in \code{"pt"}.}

\item{base_family}{\code{string}. Base font family, default is \code{"sans"}.}

\item{base_fontface}{\code{string}. Base font face, default is \code{"bold"}.}

\item{base_line_size}{\code{numeric}. Base linewidth for line elements}

\item{base_rect_size}{\code{numeric}. Base linewidth for rect elements}

\item{axis_text_angle}{\code{integer}. Angle of axis text in degrees.
One of: \verb{0, 45, 90, 270}.}

\item{border}{\code{logical}. Should a border be drawn around the plot?
Clipping will occur unless e.g. \code{coord_cartesian(clip = "off")} is used.}
}
\value{
Returns a list-like object of class \emph{theme}.
}
\description{
Modified ggprism theme which restores the legend title.
}
\examples{
# Generate a plot and customize theme
library(ggplot2)
df <- data.frame(x = rnorm(n = 100, mean = 20, sd = 2), y = rbinom(n = 100, size = 100, prob = 0.2))
p <- ggplot(data = df, mapping = aes(x = x, y = y)) + geom_point(mapping = aes(color = 'red'))
p + theme_ggprism_mod()

}
\references{
theme is a modified version of \code{theme_prism} from ggprism package \url{https://github.com/csdaw/ggprism}
(License: GPL-3).  Param text is from \code{ggprism:theme_prism()} documentation \code{\link[ggprism]{theme_prism}}.
Theme adaptation based on ggprism vignette
\url{https://csdaw.github.io/ggprism/articles/themes.html#make-your-own-ggprism-theme-1}.
}
\concept{themes}
