% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Utilities.R
\name{Add_Mito_Ribo_LIGER}
\alias{Add_Mito_Ribo_LIGER}
\title{Add Mito and Ribo percentages to LIGER}
\usage{
Add_Mito_Ribo_LIGER(
  liger_object,
  species,
  mito_name = "percent_mito",
  ribo_name = "percent_ribo",
  mito_ribo_name = "percent_mito_ribo",
  mito_pattern = NULL,
  ribo_pattern = NULL,
  mito_features = NULL,
  ribo_features = NULL,
  ensembl_ids = FALSE,
  overwrite = FALSE,
  list_species_names = FALSE
)
}
\arguments{
\item{liger_object}{LIGER object name.}

\item{species}{Species of origin for given Seurat Object.  If mouse, human, marmoset, zebrafish, rat,
drosophila, or rhesus macaque (name or abbreviation) are provided the function will automatically
generate mito_pattern and ribo_pattern values.}

\item{mito_name}{name to use for the new meta.data column containing percent mitochondrial counts.
Default is "percent_mito".}

\item{ribo_name}{name to use for the new meta.data column containing percent ribosomal counts.
Default is "percent_ribo".}

\item{mito_ribo_name}{name to use for the new meta.data column containing percent mitochondrial+ribosomal
counts.  Default is "percent_mito_ribo".}

\item{mito_pattern}{A regex pattern to match features against for mitochondrial genes (will set automatically
if species is mouse or human; marmoset features list saved separately).}

\item{ribo_pattern}{A regex pattern to match features against for ribosomal genes (will set automatically
if species is mouse, human, or marmoset).}

\item{mito_features}{A list of mitochondrial gene names to be used instead of using regex pattern.
Will override regex pattern if both are present (including default saved regex patterns).}

\item{ribo_features}{A list of ribosomal gene names to be used instead of using regex pattern.
Will override regex pattern if both are present (including default saved regex patterns).}

\item{ensembl_ids}{logical, whether feature names in the object are gene names or
ensembl IDs (default is FALSE; set TRUE if feature names are ensembl IDs).}

\item{overwrite}{Logical.  Whether to overwrite existing meta.data columns.  Default is FALSE meaning that
function will abort if columns with any one of the names provided to \code{mito_name} \code{ribo_name} or \code{mito_ribo_name}
is present in meta.data slot.}

\item{list_species_names}{returns list of all accepted values to use for default species names which
contain internal regex/feature lists (human, mouse, marmoset, zebrafish, rat, drosophila, and
rhesus macaque).  Default is FALSE.}
}
\value{
A LIGER Object
}
\description{
Add Mito, Ribo, percentages to meta.data slot of LIGER Object
}
\examples{
\dontrun{
object <- Add_Mito_Ribo_LIGER(liger_object = object, species = "mouse")
}

}
\concept{liger_object_util}
