% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_sb_text.R
\name{query_sb_text}
\alias{query_sb_text}
\title{Query SB for items containing specific text}
\usage{
query_sb_text(text, ..., limit = 20, session = current_session())
}
\arguments{
\item{text}{Text string for search}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}}

\item{limit}{Maximum number of returned items. Will do paging to retrieve
results when limit is over 1000. Use with caution, queries 10k results
are slow.}

\item{session}{Session object from \code{\link{authenticate_sb}}}
}
\value{
A list of \code{\link{sbitem}} objects. List of length 0 
means no matches were found.
}
\description{
Queries for ScienceBase items that have matching text in the title or 
description
}
\examples{
#query for a person's name
query_sb_text('Luna Leopold')

#query for one of the old river gaging stations
query_sb_text('Lees Ferry')


}
